/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.raw;

import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.text.UString;

/**
 * RPattern
 *
 * @since   Dec. 20, 1999
 * @version Nov. 19, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public abstract class RPattern extends RNode {
    private String name_;
    private String namespace_;
    private RNode[] contents_;
    private Element base_;

    protected RPattern(Element element) {
	super(element);
	name_ = UString.checkNull(element.getAttribute("role"));
	if (name_ == null) {
	    name_ = UString.checkNull(element.getAttribute("pred"));
	}
	namespace_ = UString.checkNull(element.getAttribute("namespace"));
	contents_ = URRelax.buildContents(element);
	base_ = element;
    }

    public final void setName(String name) {
	name_ = name;
    }

    public final String getName() {
	return (name_);
    }

    public String getNamespace() {
	return (namespace_);
    }

    public final RNode[] getContents() {
	return (contents_);
    }

    public final Element getBase() {
	return (base_);
    }
}
