/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.raw;

import java.util.*;
import java.io.IOException;
import java.net.URL;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.io.UURL;
import jp.gr.java_conf.jaba2.xml.*;
import jp.gr.java_conf.jaba2.xml.relax.RELAXEntityResolver;

/**
 * RGrammar
 *
 * @since   Nov. 16, 2000
 * @version May. 28, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class RGrammar {
    private List modules_ = new ArrayList();
    protected List contentRules_ = new ArrayList();
    protected List elementRules_ = new ArrayList();
    protected List tagPatterns_ = new ArrayList();
    protected List attListPatterns_ = new ArrayList();

    public RGrammar(Element element, String baseURI) {
	_buildGrammar(element, baseURI);
    }

    private void _buildGrammar(Element element, String baseURI) {
	_buildGrammarContents(element, baseURI);
    }

    private void _buildGrammarContents(
	Element element,
	String baseURI
    ) {
	Element[] elements = UElement.getElements(element);
	for (int i = 0;i < elements.length;i++) {
	    Element child = elements[i];
	    String localName = child.getLocalName();
	    if ("topLevel".equals(localName)) {
		_buildTopLevel(child);
	    } else if ("namespace".equals(localName)) {
		_buildNamespace(child, baseURI);
//	    } else if ("module".equals(localName)) {
//		_buildNamespace(child, baseURI);
	    } else if ("hedgeRule".equals(localName)) {
		RContentRule rule = new RContentRule(child);
		addContentRule(rule);
	    } else if ("elementRule".equals(localName)) {
		RElementRule rule = new RElementRule(child);
		addElementRule(rule);
	    } else if ("tag".equals(localName)) {
		RTagPattern rule = new RTagPattern(child);
		addTagPattern(rule);
	    } else if ("attPool".equals(localName)) {
		RAttListPattern rule = new RAttListPattern(child);
		addAttListPattern(rule);
	    } else if ("include".equals(localName)) {
		URL url = UElement.getAttributeAsURLByFileOrURLNameWithXMLBase(
		    child,
		    "grammarLocation",
		    baseURI
		);
		IProcessor processor = ProcessorFactory.getProcessor();
		try {
		    Document doc = processor.parseValidDocument(url);
		    _buildGrammar(
			doc.getDocumentElement(),
			UURL.getBaseURI(url)
		    );
		} catch (IOException e) {
		    throw (new RSyntaxErrorException(
			"Can not include " + url
		    ));
		}
	    } else if ("div".equals(localName)) {
		_buildGrammarContents(child, baseURI);
	    } else if ("annotation".equals(localName)) {
		// do nothing
	    } else {
		// do nothing
//		throw (new RSyntaxErrorException(
//		    "Unknown keyword " + localName
//		));
	    }
	}
    }

    private void _buildTopLevel(Element element) {
    }

    private void _buildNamespace(Element element, String baseURI) {
	URL url = UElement.getAttributeAsURLByFileOrURLNameWithXMLBase(
	    element,
	    "moduleLocation",
	    baseURI
	);
	if (url != null) {
	    _buildNamespaceWithModuleLocation(element, baseURI, url);
	} else {
	    _buildNamespaceWithoutModuleLocation(element, baseURI);
	}
    }

    private void _buildNamespaceWithModuleLocation(
	Element element,
	String baseURI,
	URL url
    ) {
	String namespaceUri = element.getAttribute("name");
	IProcessor processor = ProcessorFactory.getProcessor();
	processor.setEntityResolver(new RELAXEntityResolver());
	try {
	    Document doc = processor.parseValidDocument(url);
	    RModule module = new RModule(
		doc.getDocumentElement(),
		baseURI
	    );
	    if (namespaceUri != null) {
		module.setTargetNamespace(namespaceUri);
	    }
	    modules_.add(module);
	} catch (IOException e) {
	    throw (new RSyntaxErrorException(
		"Can not include " + url
	    ));
	}
    }

    private void _buildNamespaceWithoutModuleLocation(
	Element element,
	String baseURI
    ) {
	String namespaceUri = element.getAttribute("name");
	Element moduleElement = UElement.getOnlyElement(
	    element,
	    "http://www.xml.gr.jp/xmlns/relaxCore",
	    "module"
	);
	RModule module = new RModule(moduleElement, baseURI);
	module.setTargetNamespace(namespaceUri);
	modules_.add(module);
    }

    public void addContentRule(RContentRule rule) {
	contentRules_.add(rule);
    }

    public void addElementRule(RElementRule rule) {
	elementRules_.add(rule);
    }

    public void addTagPattern(RTagPattern pattern) {
	tagPatterns_.add(pattern);
    }

    public void addAttListPattern(RAttListPattern pattern) {
	attListPatterns_.add(pattern);
    }

    public RContentRule[] getContentRules() {
	RContentRule[] rules = new RContentRule[contentRules_.size()];
	return ((RContentRule[])contentRules_.toArray(rules));
    }

    public RElementRule[] getElementRules() {
	RElementRule[] rules = new RElementRule[elementRules_.size()];
	return ((RElementRule[])elementRules_.toArray(rules));
    }

    public RTagPattern[] getTagPatterns() {
	RTagPattern[] rules = new RTagPattern[tagPatterns_.size()];
	return ((RTagPattern[])tagPatterns_.toArray(rules));
    }

    public RAttListPattern[] getAttListPatterns() {
	RAttListPattern[] rules
	    = new RAttListPattern[attListPatterns_.size()];
	return ((RAttListPattern[])attListPatterns_.toArray(rules));
    }

    public RModule[] getModules() {
	RModule[] modules = new RModule[modules_.size()];
	return ((RModule[])modules_.toArray(modules));
    }
}

