package jp.gr.java_conf.jaba2.xml.relax.expanded.rText;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>POptional</b> is generated from pattern.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="optional">
 *   <ref name="textPatterns"/>
 * </element>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;element name="optional"&gt;
 *   &lt;ref name="textPatterns"/&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @version pattern.rng (Wed Mar 12 11:47:21 JST 2003)
 * @author  Relaxer 1.0RCb (http://www.relaxer.org)
 */
public class POptional implements java.io.Serializable, Cloneable, IRNode, IPTextPatternChoice {
    // List<IPTextPatternChoice>
    private java.util.List textPattern_ = new java.util.ArrayList();
    private IRNode parentRNode_;

    /**
     * Creates a <code>POptional</code>.
     *
     */
    public POptional() {
    }

    /**
     * Creates a <code>POptional</code>.
     *
     * @param source
     */
    public POptional(POptional source) {
        setup(source);
    }

    /**
     * Creates a <code>POptional</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public POptional(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>POptional</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public POptional(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>POptional</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public POptional(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>POptional</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public POptional(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>POptional</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public POptional(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>POptional</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public POptional(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>POptional</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public POptional(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>POptional</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public POptional(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>POptional</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public POptional(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>POptional</code> by the POptional <code>source</code>.
     *
     * @param source
     */
    public void setup(POptional source) {
        int size;
        size = source.textPattern_.size();
        for (int i = 0;i < size;i++) {
            textPattern_.add(((IPTextPatternChoice)source.textPattern_.get(i)).clone());
        }
    }

    /**
     * Initializes the <code>POptional</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>POptional</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>POptional</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        textPattern_.clear();
        while (true) {
            if (PData.isMatch(stack)) {
                addTextPattern(new PData(stack));
            } else if (PValue.isMatch(stack)) {
                addTextPattern(new PValue(stack));
            } else if (PRef.isMatch(stack)) {
                addTextPattern(new PRef(stack));
            } else if (PDefine.isMatch(stack)) {
                addTextPattern(new PDefine(stack));
            } else if (PElement.isMatch(stack)) {
                addTextPattern(new PElement(stack));
            } else if (PAttribute.isMatch(stack)) {
                addTextPattern(new PAttribute(stack));
            } else if (PList.isMatch(stack)) {
                addTextPattern(new PList(stack));
            } else if (PChoice.isMatch(stack)) {
                addTextPattern(new PChoice(stack));
            } else if (POneOrMore.isMatch(stack)) {
                addTextPattern(new POneOrMore(stack));
            } else if (PZeroOrMore.isMatch(stack)) {
                addTextPattern(new PZeroOrMore(stack));
            } else if (PGroup.isMatch(stack)) {
                addTextPattern(new PGroup(stack));
            } else if (PExcept.isMatch(stack)) {
                addTextPattern(new PExcept(stack));
            } else if (PText.isMatch(stack)) {
                addTextPattern(new PText(stack));
            } else if (PNotAllowed.isMatch(stack)) {
                addTextPattern(new PNotAllowed(stack));
            } else if (PEmpty.isMatch(stack)) {
                addTextPattern(new PEmpty(stack));
            } else if (POptional.isMatch(stack)) {
                addTextPattern(new POptional(stack));
            } else {
                break;
            }
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new POptional(this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("optional");
        int size;
        size = this.textPattern_.size();
        for (int i = 0;i < size;i++) {
            IPTextPatternChoice value = (IPTextPatternChoice)this.textPattern_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>POptional</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>POptional</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>POptional</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>POptional</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>POptional</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>POptional</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the IPTextPatternChoice property <b>textPattern</b>.
     *
     * @return IPTextPatternChoice[]
     */
    public final IPTextPatternChoice[] getTextPattern() {
        IPTextPatternChoice[] array = new IPTextPatternChoice[textPattern_.size()];
        return ((IPTextPatternChoice[])textPattern_.toArray(array));
    }

    /**
     * Sets the IPTextPatternChoice property <b>textPattern</b>.
     *
     * @param textPattern
     */
    public final void setTextPattern(IPTextPatternChoice[] textPattern) {
        this.textPattern_.clear();
        for (int i = 0;i < textPattern.length;i++) {
            addTextPattern(textPattern[i]);
        }
        for (int i = 0;i < textPattern.length;i++) {
            textPattern[i].rSetParentRNode(this);
        }
    }

    /**
     * Sets the IPTextPatternChoice property <b>textPattern</b>.
     *
     * @param textPattern
     */
    public final void setTextPattern(IPTextPatternChoice textPattern) {
        this.textPattern_.clear();
        addTextPattern(textPattern);
        if (textPattern != null) {
            textPattern.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IPTextPatternChoice property <b>textPattern</b>.
     *
     * @param textPattern
     */
    public final void addTextPattern(IPTextPatternChoice textPattern) {
        this.textPattern_.add(textPattern);
        if (textPattern != null) {
            textPattern.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IPTextPatternChoice property <b>textPattern</b>.
     *
     * @param textPattern
     */
    public final void addTextPattern(IPTextPatternChoice[] textPattern) {
        for (int i = 0;i < textPattern.length;i++) {
            addTextPattern(textPattern[i]);
        }
        for (int i = 0;i < textPattern.length;i++) {
            textPattern[i].rSetParentRNode(this);
        }
    }

    /**
     * Gets number of the IPTextPatternChoice property <b>textPattern</b>.
     *
     * @return int
     */
    public final int getTextPatternCount() {
        return (textPattern_.size());
    }

    /**
     * Gets the IPTextPatternChoice property <b>textPattern</b> by index.
     *
     * @param index
     * @return IPTextPatternChoice
     */
    public final IPTextPatternChoice getTextPattern(int index) {
        return ((IPTextPatternChoice)textPattern_.get(index));
    }

    /**
     * Sets the IPTextPatternChoice property <b>textPattern</b> by index.
     *
     * @param index
     * @param textPattern
     */
    public final void setTextPattern(int index, IPTextPatternChoice textPattern) {
        this.textPattern_.set(index, textPattern);
    }

    /**
     * Adds the IPTextPatternChoice property <b>textPattern</b> by index.
     *
     * @param index
     * @param textPattern
     */
    public final void addTextPattern(int index, IPTextPatternChoice textPattern) {
        this.textPattern_.add(index, textPattern);
    }

    /**
     * Remove the IPTextPatternChoice property <b>textPattern</b> by index.
     *
     * @param index
     */
    public final void removeTextPattern(int index) {
        this.textPattern_.remove(index);
    }

    /**
     * Remove the IPTextPatternChoice property <b>textPattern</b> by object.
     *
     * @param textPattern
     */
    public final void removeTextPattern(IPTextPatternChoice textPattern) {
        this.textPattern_.remove(textPattern);
    }

    /**
     * Clear the IPTextPatternChoice property <b>textPattern</b>.
     *
     */
    public final void clearTextPattern() {
        this.textPattern_.clear();
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<optional");
        size = this.textPattern_.size();
        for (int i = 0;i < size;i++) {
            IPTextPatternChoice value = (IPTextPatternChoice)this.textPattern_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.append(">");
        size = this.textPattern_.size();
        for (int i = 0;i < size;i++) {
            IPTextPatternChoice value = (IPTextPatternChoice)this.textPattern_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</optional>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        buffer.write("<optional");
        size = this.textPattern_.size();
        for (int i = 0;i < size;i++) {
            IPTextPatternChoice value = (IPTextPatternChoice)this.textPattern_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.write(">");
        size = this.textPattern_.size();
        for (int i = 0;i < size;i++) {
            IPTextPatternChoice value = (IPTextPatternChoice)this.textPattern_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</optional>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<optional");
        size = this.textPattern_.size();
        for (int i = 0;i < size;i++) {
            IPTextPatternChoice value = (IPTextPatternChoice)this.textPattern_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.print(">");
        size = this.textPattern_.size();
        for (int i = 0;i < size;i++) {
            IPTextPatternChoice value = (IPTextPatternChoice)this.textPattern_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</optional>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode rGetParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] rGetRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(textPattern_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>POptional</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "optional")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        while (true) {
            if (PData.isMatchHungry(target)) {
                $match$ = true;
            } else if (PValue.isMatchHungry(target)) {
                $match$ = true;
            } else if (PRef.isMatchHungry(target)) {
                $match$ = true;
            } else if (PDefine.isMatchHungry(target)) {
                $match$ = true;
            } else if (PElement.isMatchHungry(target)) {
                $match$ = true;
            } else if (PAttribute.isMatchHungry(target)) {
                $match$ = true;
            } else if (PList.isMatchHungry(target)) {
                $match$ = true;
            } else if (PChoice.isMatchHungry(target)) {
                $match$ = true;
            } else if (POneOrMore.isMatchHungry(target)) {
                $match$ = true;
            } else if (PZeroOrMore.isMatchHungry(target)) {
                $match$ = true;
            } else if (PGroup.isMatchHungry(target)) {
                $match$ = true;
            } else if (PExcept.isMatchHungry(target)) {
                $match$ = true;
            } else if (PText.isMatchHungry(target)) {
                $match$ = true;
            } else if (PNotAllowed.isMatchHungry(target)) {
                $match$ = true;
            } else if (PEmpty.isMatchHungry(target)) {
                $match$ = true;
            } else if (POptional.isMatchHungry(target)) {
                $match$ = true;
            } else {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>POptional</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>POptional</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
