/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2003  ASAMI, Tomoharu (asami@AsamiOffice.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.expanded;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.util.ArrayMap;
import jp.gr.java_conf.jaba2.xml.relax.cooked.*;

/**
 * ERelax
 *
 * @since   Jan.  2, 2000
 * @version Sep. 11, 2003
 * @author  ASAMI, Tomoharu (asami@AsamiOffice.com)
 */
public class ERelax implements IEOccurs {
    private EGrammar grammar_;
    private ArrayMap modules_ = new ArrayMap();
    private Map exportLabels_;

    public ERelax(CRelax crelax) {
	CGrammar cGrammar = crelax.getGrammar();
	if (cGrammar != null) {
	    grammar_ = new EGrammar(cGrammar);
	}
	CModule[] cmodules = crelax.getModules();
	for (int i = 0;i < cmodules.length;i++) {
	    EModule module = new EModule(cmodules[i]);
	    module.setModel(this);
	    modules_.put(module.getTargetNamespace(), module);
	}
	int size = modules_.size();
	for (int i = 0;i < size;i++) {
	    EModule module = (EModule)modules_.get(i);
	    module.resolveExternalRefs();
	    module.resolveExternalRoleRefs();
	}
	_optimize();
/*
	for (int i = 0;i < size;i++) {
	    EModule module = (EModule)modules_.get(i);
	    module.adjustTree();
	}
*/
        exportLabels_ = crelax.getExportLabels();
    }

    private void _optimize() {
	OptimizerController controller = new OptimizerController();
	int size = modules_.size();
	for (int i = 0;i < size;i++) {
	    EModule module = (EModule)modules_.get(i);
	    module.setup(controller);
	}
	controller.optimize();
    }

    public EModule[] getModules() {
	int size = modules_.size();
	EModule[] modules = new EModule[size];
	for (int i = 0;i < size;i++) {
	    modules[i] = (EModule)modules_.get(i);
	}
	return (modules);
    }

    public EModule getModule(String namespace) {
	return ((EModule)modules_.get(namespace));
    }

    public ENode resolveExternalRef(EExternalRefNode node) {
	String namespace = node.getNamespace();
	String label = node.getLabel();
	EModule module = getModule(namespace);
	if (module == null) {
	    throw (new ESyntaxErrorException("no namespace : " + namespace));
	}
	EElementNode[] erules = module.resolveElementLabel(label);
	if (erules != null) {
	    return (_resolveExternalRef(node, erules));
	}
	EContentNode[] crules = module.resolveContentLabel(label);
	if (crules != null) {
	    return (_resolveExternalRef(node, crules));
	}
	throw (new ESyntaxErrorException(
	    "no rule '" + label + "' in " + namespace));
    }

    private ENode _resolveExternalRef(
	EExternalRefNode node,
	EElementNode[] eRules
    ) {
	String namespace = node.getNamespace();
	String label = node.getLabel();
	int occurs = node.getOccurs();
	if (eRules.length == 1) {
	    node.setElementNode(eRules[0]);
	    return (node);
	} else {
	    EChoiceNode choice = new EChoiceNode(occurs);
	    choice.setConflict(true); // XXX
	    for (int i = 0;i < eRules.length;i++) {
		EExternalRefNode refNode
		    = new EExternalRefNode(namespace, label, OCCURS_ONE);
		refNode.setElementNode(eRules[i]);
		choice.addChild(refNode);
	    }
	    return (choice);
	}
    }

    private ENode _resolveExternalRef(
	EExternalRefNode node,
	EContentNode[] cRules
    ) {
	String namespace = node.getNamespace();
	String label = node.getLabel();
	int occurs = node.getOccurs();
	if (cRules.length == 1) {
	    EExternalContentRefNode refNode
		= new EExternalContentRefNode(namespace, label, occurs);
	    refNode.setContentNode(cRules[0]);
	    return (refNode);
	} else {
	    EChoiceNode choice = new EChoiceNode(occurs);
	    choice.setConflict(true); // XXX
	    for (int i = 0;i < cRules.length;i++) {
		EExternalContentRefNode refNode
		    = new EExternalContentRefNode(
			namespace,
			label,
			OCCURS_ONE
		    );
		refNode.setContentNode(cRules[i]);
		choice.addChild(refNode);
	    }
	    return (choice);
	}
    }

    public ENode[] resolveExternalRoleRef(EExternalRoleRefNode node) {
	String namespace = node.getNamespace();
	String role = node.getRole();
	EModule module = getModule(namespace);
	if (module == null) {
	    throw (new ESyntaxErrorException("no namespace : " + namespace));
	}
	return (module.resolveAttListRole(node.getRole()));
    }

    public Map getExportLabels() {
        return (exportLabels_);
    }
}
