/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2003  ASAMI, Tomoharu (asami@AsamiOffice.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.expanded;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.xml.relax.cooked.*;

/**
 * EInterleaveNode
 *
 * @since   May. 10, 2002
 * @version May. 15, 2003
 * @author  ASAMI, Tomoharu (asami@AsamiOffice.com)
 */
public class EInterleaveNode extends ENode implements IEOccurs {
    private int occurs_;
    private boolean mixed_ = false;

    public EInterleaveNode() {
	this(OCCURS_ONE);
    }

    public EInterleaveNode(int occurs) {
	super("interleave");
	if (occurs != OCCURS_ONE &&
	    occurs != OCCURS_ZEROONE &&
	    occurs != OCCURS_ONEMORE &&
	    occurs != OCCURS_ZEROMORE) {

	    throw (new InternalError());
	}
	occurs_ = occurs;
	setAttribute("occurs", UERule.getOccursSymbol(occurs));
    }

    public EInterleaveNode(EInterleaveNode iNode) {
	super(iNode);
	occurs_ = iNode.occurs_;
	setAttribute("occurs", UERule.getOccursSymbol(occurs_));
	addChildrenDeep(iNode);
    }

    public final int getOccurs() {
	return (occurs_);
    }

    public final void setOccurs(int occurs) {
	occurs_ = occurs;
    }

    public final boolean getMixed() {
	return (mixed_);
    }

    public final void setMixed(boolean mixed) {
	mixed_ = mixed;
    }

    public boolean enter(IEVisitor visitor) {
	return (visitor.enter(this));
    }

    public void leave(IEVisitor visitor) {
	visitor.leave(this);
    }
}
