/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@AsamiOffice.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.expanded;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.datatype.*;
import jp.gr.java_conf.jaba2.xml.datatype.*;
import jp.gr.java_conf.jaba2.xml.relax.cooked.*;

/**
 * EDataSlot
 *
 * @since   Apr. 19, 2002
 * @version Jul. 12, 2002
 * @author  ASAMI, Tomoharu (asami@AsamiOffice.com)
 */
public class EDataSlot extends ENode implements IEOccurs {
    private IXMLDatatype datatype_;

    public EDataSlot(CData data) {
	super("data");
	datatype_ = data.getDatatype();
	_setup();
    }

    public EDataSlot(EDataSlot slot) {
	super(slot);
	datatype_ = slot.datatype_;
	_setup();
    }

    public EDataSlot(IXMLDatatype datatype) {
	super("data");
	datatype_ = datatype;
	_setup();
    }

    private void _setup() {
	setAttribute("type", datatype_.getName());
	setAttribute("list", datatype_.isList() ? "true" : "false");
    }

    public final IXMLDatatype getDatatype() {
	return (datatype_);
    }

    public boolean enter(IEVisitor visitor) {
	return (visitor.enter(this));
    }

    public void leave(IEVisitor visitor) {
	visitor.leave(this);
    }
}
