/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2003  ASAMI, Tomoharu (asami@AsamiOffice.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.cooked;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.xml.datatype.*;
import jp.gr.java_conf.jaba2.xml.relax.raw.RElement;
import jp.gr.java_conf.jaba2.xml.relax.raw.RAttribute;

/**
 * CValue
 *
 * @since   Jul. 27, 2001
 * @version Jul. 12, 2003
 * @author  ASAMI, Tomoharu (asami@AsamiOffice.com)
 */
public class CValue extends CNode implements ICPatternContent, ICParticle {
    private String text_;
    private String xmlType_;

    public CValue(String text) {
	text_ = text;
	xmlType_ = "string";
    }

    public CValue(String text, String xmlType) {
	text_ = text;
	xmlType_ = xmlType;
    }

    public CValue(CValue value) {
        text_ = value.text_;
        xmlType_ = value.xmlType_;
    }

    public final String getText() {
	return (text_);
    }

    public final String getType() {
	return (xmlType_);
    }
}
