/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2003  ASAMI, Tomoharu (asami@AsamiOffice.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.cooked;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.datatype.XMLFacet;
import jp.gr.java_conf.jaba2.xml.datatype.*;
import jp.gr.java_conf.jaba2.util.MultiValueMap;
import jp.gr.java_conf.jaba2.xml.relax.raw.*;

/**
 * CModule
 *
 * @since   Dec. 20, 1999
 * @version Oct. 21, 2003
 * @author  ASAMI, Tomoharu (asami@AsamiOffice.com)
 */
public class CModule {
    private static int patternStamp__ = 0;

    private static int _getPatternStamp() {
        return (patternStamp__++);
    }

    protected String fileURI_;
    protected String baseURI_;
    protected String moduleVersion_;
    protected String relaxCoreVersion_;
    protected String targetNamespace_;
    protected List exportLabels_ = new ArrayList();
    protected String[] exportRoles_;
    protected String[] importLabels_;
    protected String[] importRoles_;
    protected Map simpleTypes_ = new HashMap();
    protected MultiValueMap contentRules_ = new MultiValueMap(
        new CContentRule[0]
    );
    protected MultiValueMap elementRules_ = new MultiValueMap(
        new CElementRule[0]
    );
    protected MultiValueMap tagPatterns_ = new MultiValueMap(
        new CTagPattern[0]
    );
    protected MultiValueMap attListPatterns_ = new MultiValueMap(
        new CAttListPattern[0]
    );

    public CModule(String namespace) {
        targetNamespace_ = namespace;
    }

    public CModule(RModule rmodule) {
        moduleVersion_ = rmodule.getModuleVersion();
        relaxCoreVersion_ = rmodule.getRelaxCoreVersion();
        targetNamespace_ = rmodule.getTargetNamespace();
        exportLabels_.addAll(Arrays.asList(rmodule.getExportLabels()));
        exportRoles_ = rmodule.getExportRoles();
        if (exportLabels_.size() == 0 && exportRoles_.length == 0) {
            throw (new CSyntaxErrorException("no export"));
        }
        importLabels_ = rmodule.getImportLabels();
        importRoles_ = rmodule.getImportRoles();
        RSimpleType[] rtypes = rmodule.getSimpleTypes();
        RContentRule[] rcrules = rmodule.getContentRules();
        RElementRule[] rerules = rmodule.getElementRules();
        RTagPattern[] rtpatterns = rmodule.getTagPatterns();
        RAttListPattern[] rapatterns = rmodule.getAttListPatterns();
        _buildSimpleTypes(rtypes);
        for (int i = 0;i < rcrules.length;i++) {
            CContentRule rule = _makeContentRule(rcrules[i]);
            addContentRule(rule);
        }
        for (int i = 0;i < rerules.length;i++) {
            CElementRule rule = _makeElementRule(rerules[i]);
            addElementRule(rule);
        }
        for (int i = 0;i < rtpatterns.length;i++) {
            CTagPattern pattern = _makeTagPattern(rtpatterns[i]);
            addTagPattern(pattern);
        }
        for (int i = 0;i < rapatterns.length;i++) {
            addAttListPattern(rapatterns[i]);
//            CAttListPattern pattern = _makeAttListPattern(rapatterns[i]);
//            addAttListPattern(pattern);
        }
        if (importLabels_ != null) {
            for (int i = 0;i < importLabels_.length;i++) {
                addContentRule(new CNoneContentRule(importLabels_[i]));
            }
        }
    }

    public void setTargetNamespace(String namespace) {
        targetNamespace_ = namespace;
    }

    public void addExportLabel(String label) {
//System.out.println("add label = " + label);
//System.out.println("ns = " + targetNamespace_);
        if (!exportLabels_.contains(label)) {
            exportLabels_.add(label);
        }
    }

    public void addReferencedLabel(String label) {
        addExportLabel(label);  // XXX
    }

    public void addContentRule(RContentRule rule) {
        CContentRule crule = _makeContentRule(rule);
        addContentRule(crule);
    }

    public void addAttListPattern(RAttListPattern rPattern) {
        CAttListPattern[] cRegistered = getAttListPatterns(rPattern.getName());
        if (cRegistered == null) {
            CAttListPattern cPattern = _makeAttListPattern(rPattern);
            addAttListPattern(cPattern);
        } else if (cRegistered.length == 1) {
            CAttListPattern cPattern = cRegistered[0];
            cPattern.combinePattern(rPattern);
        } else {
            throw (new InternalError());
        }
    }

    public void setFileURI(String uri) {
        fileURI_ = uri;
    }

    public void setBaseURI(String uri) {
        baseURI_ = uri;
    }

    public String getFileURI() {
        return (fileURI_);
    }

    public String getBaseURI() {
        return (baseURI_);
    }

    public String getModuleVersion() {
        return (moduleVersion_);
    }

    public String getRelaxCoreVersion() {
        return (relaxCoreVersion_);
    }

    public String getTargetNamespace() {
        return (targetNamespace_);
    }

    public String[] getExportLabels() {
        String[] labels = new String[exportLabels_.size()];
        return ((String[])exportLabels_.toArray(labels));
    }

    public String[] getExportRoles() {
        return (exportRoles_);
    }

    public String[] getImportLabels() {
        return (importLabels_);
    }

    public String[] getImportRoles() {
        return (importRoles_);
    }

    public boolean isImportRole(String role) {
        if (importRoles_ == null) {
            return (false);
        }
        for (int i = 0;i < importRoles_.length;i++) {
            if (role.equals(importRoles_[i])) {
                return (true);
            }
        }
        return (false);
    }

    public CContentRule[] getContentRules(String label) {
        return ((CContentRule[])contentRules_.get(label));
    }

    public CElementRule[] getElementRules(String label) {
        return ((CElementRule[])elementRules_.get(label));
    }

    public CTagPattern[] getTagPatterns(String pattern) {
        return ((CTagPattern[])tagPatterns_.get(pattern));
    }

    public CAttListPattern[] getAttListPatterns(String pattern) {
        return ((CAttListPattern[])attListPatterns_.get(pattern));
    }

    public CElementRule[] getElementRules() {
        List list = new ArrayList();
        Collection values = elementRules_.values();
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            CElementRule[] rules = (CElementRule[])iter.next();
            list.addAll(Arrays.asList(rules));
        }
        CElementRule[] result = new CElementRule[list.size()];
        return ((CElementRule[])list.toArray(result));
    }

    public CContentRule[] getContentRules() {
        List list = new ArrayList();
        Collection values = contentRules_.values();
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            CContentRule[] rules = (CContentRule[])iter.next();
            list.addAll(Arrays.asList(rules));
        }
        CContentRule[] result = new CContentRule[list.size()];
        return ((CContentRule[])list.toArray(result));
    }

    public CTagPattern[] getTagPatterns() {
        List list = new ArrayList();
        Collection values = tagPatterns_.values();
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            CTagPattern[] patterns = (CTagPattern[])iter.next();
            list.addAll(Arrays.asList(patterns));
        }
        CTagPattern[] result = new CTagPattern[list.size()];
        return ((CTagPattern[])list.toArray(result));
    }

    public CAttListPattern[] getAttListPatterns() {
        List list = new ArrayList();
        Collection values = attListPatterns_.values();
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            CAttListPattern[] patterns = (CAttListPattern[])iter.next();
            list.addAll(Arrays.asList(patterns));
        }
        CAttListPattern[] result = new CAttListPattern[list.size()];
        return ((CAttListPattern[])list.toArray(result));
    }

    public void addContentRule(CContentRule rule) {
        contentRules_.add(rule.getLabel(), rule);
    }

    public void addElementRule(CElementRule rule) {
        elementRules_.add(rule.getLabel(), rule);
    }

    public void addTagPattern(CTagPattern pattern) {
        tagPatterns_.add(pattern.getName(), pattern);
    }

    public void addAttListPattern(CAttListPattern pattern) {
        attListPatterns_.add(pattern.getName(), pattern);
    }

    public CSimpleType getSimpleType(String name) {
        return ((CSimpleType)simpleTypes_.get(name));
    }

    public Datatype makeDatatype(String name) {
        CSimpleType stype = getSimpleType(name);
        if (stype != null) {
            return (stype.makeDatatype());
        } else {
            Datatype datatype = DatatypeFactory.getDatatype(name);
            if (datatype == null) {
                throw (
                    new CSyntaxErrorException(
                        "Invalid data type \"" + name + "\""
                    )
                );
            }
            return (datatype);
        }
    }

    public Datatype makeDatatype(String name, XMLFacet[] facets) {
        Datatype datatype = makeDatatype(name);
        if (facets != null) {
            datatype.addFacets(facets);
        }
        return (datatype);
    }

    public Datatype makeDatatype(String name, Element facets) {
        Datatype datatype = makeDatatype(name);
        if (facets != null) {
            datatype.addFacets(facets);
        }
        return (datatype);
    }

    private void _buildSimpleTypes(RSimpleType[] rtypes) {
        if (rtypes.length == 0) {
            return;
        }
        List listTypes = new ArrayList();
        List unResolvedTypes = new LinkedList();
        for (int i = 0;i < rtypes.length;i++) {
            RSimpleType rtype = rtypes[i];
            String baseName = rtype.getBaseName();
            if (baseName != null) {
                Datatype datatype = DatatypeFactory.getDatatype(baseName);
                if (datatype != null) {
                    datatype.addFacets(rtype.getRestriction());
                    simpleTypes_.put(
                        rtype.getName(),
                        new CSimpleType(datatype)
                    );
                } else {
                    unResolvedTypes.add(rtype);
                }
            } else if (rtype.getListItemType() != null) {
                listTypes.add(rtype);
            } else {
                throw (
                    new RSyntaxErrorException(
                        "Invalid simpleType \"" + rtype.getName() + "\""
                    )
                );
            }
        }
        for (;;) {
            int size = unResolvedTypes.size();
            if (size == 0) {
                break;
            }
            for (int i = 0;i < size;i++) {
                RSimpleType rtype = (RSimpleType)unResolvedTypes.get(i);
                String baseName = rtype.getBaseName();
                if (baseName == null) {
                    throw (new InternalError(rtype.getName()));
                }
                CSimpleType baseType
                    = (CSimpleType)simpleTypes_.get(baseName);
                if (baseType != null) {
                    Datatype datatype = baseType.makeDatatype();
                    datatype.addFacets(rtype.getRestriction());
                    simpleTypes_.put(
                        rtype.getName(),
                        new CSimpleType(datatype)
                    );
                    unResolvedTypes.remove(rtype);
                }
            }
            if (unResolvedTypes.size() == size) {
                new RSyntaxErrorException(
                    "unresolved simpleType"
                );
            }
        }
        int size = listTypes.size();
        for (int i = 0;i < size;i++) {
            RSimpleType rtype = (RSimpleType)listTypes.get(i);
            String itemType = rtype.getListItemType();
            Datatype datatype = DatatypeFactory.getDatatype(itemType);
            if (datatype == null) {
                CSimpleType atomicType
                    = (CSimpleType)simpleTypes_.get(itemType);
                if (atomicType == null) {
                    throw (
                        new RSyntaxErrorException(
                            "Invalid simpleType \"" + rtype.getName() + "\""
                        )
                    );
                }
                datatype = atomicType.makeDatatype();
            }
            datatype.setListOneMore(true);
            simpleTypes_.put(rtype.getName(), new CSimpleType(datatype));
        }
    }

    protected CContentRule _makeContentRule(RContentRule rrule) {
        RNode[] contents = rrule.getContents();
        if (contents == null) {
            throw (new InternalError());
        }
/*
        if (contents.length != 1) { // XXX
            throw (new InternalError());
        }
*/
        RNode node = contents[0];
        if (node instanceof RRef) {
            return (new CRefContentRule(rrule, (RRef)node, this));
        } else if (node instanceof RChoice) {
            return (new CChoiceContentRule(rrule, (RChoice)node, this));
        } else if (node instanceof RSequence) {
            return (new CSequenceContentRule(rrule, (RSequence)node, this));
        } else if (node instanceof RElement) {
            return (new CElementContentRule(rrule, (RElement)node, this));
        } else if (node instanceof RNone) {
            return (new CNoneContentRule(rrule, (RNone)node, this));
        } else if (node instanceof REmpty) {
            return (new CEmptyContentRule(rrule, (REmpty)node, this));
        } else if (node instanceof RMixed) {
            return (new CMixedContentRule(rrule, (RMixed)node, this));
        } else {
            throw (new InternalError());
        }
    }

    protected CElementRule _makeElementRule(RElementRule rrule) {
        RNode[] contents = rrule.getContents();
        if (contents == null) {
            throw (new InternalError());
        }
/*
        if (contents.length > 1) { // XXX
            throw (new CSyntaxErrorException(
                "elementRule " + rrule.getLabel() + "has more than 2 elements"
            ));
        }
*/
/*
        if (contents.length == 0) {
            if (rrule.getType() == null) {
                throw (new CSyntaxErrorException(
                    "elementRule " + rrule.getLabel() + " has no type"
                ));
            }
            return (new CTypeElementRule(rrule));
        }
*/
        for (int i = 0;i < contents.length;i++) {
            RNode node = contents[i];
            if (node instanceof RTagPattern) {
                RTagPattern tagPattern = (RTagPattern)node;
                String label = rrule.getLabel();
                if (label == null) {
                    throw (
                        new CSyntaxErrorException(
                            "some elementRule with tag has no label"
                        )
                    );
                }
                String tagName = tagPattern.getTagName();
                if (tagName == null) {
                    tagName = label;
                    tagPattern.setTagName(tagName);
                }
                String patternName
                    = label + tagName + _getPatternStamp() + "<Role>";
                rrule.setPattern(patternName);
                tagPattern.setName(patternName);
                CTagPattern pattern = _makeTagPattern(tagPattern);
                addTagPattern(pattern);
            } else if (node instanceof RAttListPattern) {
                RAttListPattern attListPattern = (RAttListPattern)node;
                String label = rrule.getLabel();
                if (label == null) {
                    throw (
                        new CSyntaxErrorException(
                            "some elementRule with attList has no label"
                        )
                    );
                }
                String roleName = attListPattern.getName();
                String patternName
                    = label + roleName + _getPatternStamp() + "_<Role>";
                rrule.setPattern(patternName);
                attListPattern.setName(patternName);
                CAttListPattern pattern = _makeAttListPattern(attListPattern);
                addAttListPattern(pattern);
            }
        }
        if (rrule.getType() != null) {
            return (new CTypeElementRule(rrule, this));
        }
        for (int i = 0;i < contents.length;i++) {
            RNode node = contents[i];
            if (node instanceof RRef) {
                return (new CRefElementRule(rrule, (RRef)node, this));
            } else if (node instanceof RChoice) {
                return (new CChoiceElementRule(rrule, (RChoice)node, this));
            } else if (node instanceof RSequence) {
                return (
                    new CSequenceElementRule(rrule, (RSequence)node, this)
                );
            } else if (node instanceof RElement) {
                return (new CElementElementRule(rrule, (RElement)node, this));
            } else if (node instanceof RNone) {
                return (new CNoneElementRule(rrule, (RNone)node, this));
            } else if (node instanceof REmpty) {
                return (new CEmptyElementRule(rrule, (REmpty)node, this));
            } else if (node instanceof RMixed) {
                return (new CMixedElementRule(rrule, (RMixed)node, this));
            } else if (node instanceof RImportedLabelRef) {
                return (
                    new CRefElementRule(
                        rrule,
                        (RImportedLabelRef)node,
                        this
                    )
                );
            } else if (node instanceof RTagPattern) {
                // do nothing
            } else {
                throw (new InternalError());
            }
        }
        throw (
            new CSyntaxErrorException(
                "invalid elementRule " + rrule.getLabel()
            )
        );
    }

    protected CTagPattern _makeTagPattern(RTagPattern rpattern) {
        return (new CTagPattern(rpattern, this));
    }

    protected CAttListPattern _makeAttListPattern(RAttListPattern rpattern) {
        return (new CAttListPattern(rpattern, this));
    }
}
