/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.datatype;

import java.util.*;
import org.w3c.dom.*;

/**
 * DDecimal
 *
 * @since   Feb. 23, 2000
 * @version Dec. 13, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class DDecimal extends Datatype {
    // facets
    private Integer precision_;
    private Integer scale_;
    private Integer maxInclusive_;
    private Integer maxExclusive_;
    private Integer minInclusive_;
    private Integer minExclusive_;
    private Integer[] enumeration_;

    public DDecimal() {
    }

    public DDecimal(Element element) {
    }

    public String getName() {
	return ("decimal");
    }

    public final Integer getPrecision() {
	return (precision_);
    }

    public final Integer getScale() {
	return (scale_);
    }

    public final Integer getMaxInclusive() {
	return (maxInclusive_);
    }

    public final Integer getMaxExclusive() {
	return (maxExclusive_);
    }

    public final Integer getMinInclusive() {
	return (minInclusive_);
    }

    public final Integer getMinExclusive() {
	return (minExclusive_);
    }

    public final Integer[] getEnumeration() {
	return (enumeration_);
    }

    public Object makeObject(String cdata) {
	return (Integer.valueOf(cdata)); // XXX
    }
}
