/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.vfs.jar;

import java.io.*;
import java.util.jar.*;
import jp.gr.java_conf.jaba2.text.UString;
import jp.gr.java_conf.jaba2.io.UFile;
import jp.gr.java_conf.jaba2.vfs.*;

/**
 * JarObject
 *
 * @since   Jan. 25, 2000
 * @version Jan. 27, 2000
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class JarObject extends AbstractVFSObject {
    private JarEntry jar_;
    private File dirty_ = null;

    public JarObject(JarEntry jar) {
	super(UString.getLastComponent(jar.getName()));
	jar_ = jar;
    }

    public long getModifiedTime() {
	return (jar_.getTime());
    }

    public InputStream openInputStream() throws IOException {
	if (dirty_ == null) {
	    JarRealm realm = (JarRealm)getRealm();
	    return (realm.getJarFile().getInputStream(jar_));
	} else {
	    return (new FileInputStream(dirty_));
	}
    }

    public void setData(InputStream in) throws IOException {
	dirty_ = File.createTempFile("jaba2", "tmp");
	dirty_.deleteOnExit();
	UFile.createFile(dirty_, in);
    }

    public boolean isDirty() {
	return (dirty_ != null);
    }

    public void clear() throws IOException {
	dirty_ = null;
    }
}
