/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.vfs.filter;

import java.util.*;
import jp.gr.java_conf.jaba2.vfs.*;

/**
 * AndFilter
 *
 * @since   Jan. 24, 2000
 * @version Jan. 26, 2000
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class AndFilter implements IFilter {
    private IFilter [] policies_;

    public AndFilter(IFilter filter1, IFilter filter2) {
	policies_ = new IFilter[2];
	policies_[0] = filter1;
	policies_[1] = filter2;
    }

    public AndFilter(IFilter filter1, IFilter filter2, IFilter filter3) {
	policies_ = new IFilter[3];
	policies_[0] = filter1;
	policies_[1] = filter2;
	policies_[2] = filter3;
    }

    public AndFilter(IFilter[] policies) {
	policies_ = new IFilter[policies.length];
	System.arraycopy(policies, 0, policies_, 0, policies.length);
    }

    public AndFilter(Collection policies) {
	policies_ = new IFilter[policies.size()];
	policies_ = (IFilter[])policies.toArray(policies_);
    }

    public boolean isMatch(IVFSNode node) {
	for (int i = 0;i < policies_.length;i++) {
	    if (!policies_[i].isMatch(node)) {
		return (false);
	    }
	}
	return (true);
    }
}
