/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.vfs;

import java.util.Date;
import java.io.*;

/**
 * IVFSRealm
 *
 * @since   Dec. 18, 1998
 * @version Feb.  8, 2000
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public interface IVFSRealm {
    void shallowSetup(IFilter filter) throws IOException;
    void deepSetup(IFilter filter) throws IOException;
    void flush() throws IOException;
    IVFSRoot getRoot();
    long getLastTimestamp() throws IOException;
    void updateTimestamp() throws IOException;
    String[] getTargetPathnames();
    IVFSObject[] getTargetObjects();
    void createObject(String pathname, InputStream in) throws IOException;
    void createContainer(String pathname, InputStream in) throws IOException;
}
