/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.tmodel;

import java.util.*;
import java.sql.*;

/**
 * TTypeCHAR
 *
 * @since   Feb. 18, 2000
 * @version Dec. 13, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class TTypeCHAR implements ITType, ITSizable {
    private int size_;

    public TTypeCHAR(int size) {
	size_ = size;
    }

    public String getName() {
	return ("CHAR");
    }

    public String getDDLName() {
	return ("CHAR(" + size_ + ")");
    }

    public int getSize() {
	return (size_);
    }

    public int getSQLType() {
	return (Types.CHAR);
    }

    public Class getJavaType() {
	return (String.class);
    }

    public Object string2Object(String string) {
	return (string);
    }

    public String object2String(Object object) {
	return (object.toString());
    }
}
