/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.tmodel;

import java.util.*;
import java.sql.*;

/**
 * TTypeBLOB
 *
 * @since   Feb.  8, 2001
 * @version Feb.  8, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class TTypeBLOB implements ITType {
    public String getName() {
	return ("BLOB");
    }

    public String getDDLName() {
	return ("BLOB");
    }

    public int getSQLType() {
	return (Types.BLOB);
    }

    public Class getJavaType() {
	return (byte[].class);
    }

    public Object string2Object(String string) {
	return (string);	// XXX : BASE64
    }

    public String object2String(Object object) {
	return (object.toString()); // XXX : BASE64
    }
}
