/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@AsamiOffice.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.tmodel;

import java.util.*;
import jp.gr.java_conf.jaba2.datatype.ISQLDatatype;

/**
 * TMetadata
 *
 * @since   Feb. 14, 2000
 * @version Oct. 14, 2002
 * @author  ASAMI, Tomoharu (asami@AsamiOffice.com)
 */
public class TMetadata {
    private List info_ = new ArrayList();

    public final void addColumnInfo(String name, ISQLDatatype type) {
	addColumnInfo(new TColumnInfo(name, type));
    }

    public final void addColumnInfo(TColumnInfo column) {
	info_.add(column);
    }

    public final TColumnInfo[] getColumnInfos() {
	TColumnInfo[] infos = new TColumnInfo[info_.size()];
	return ((TColumnInfo[])info_.toArray(infos));
    }

    public final TColumnInfo[] getPrimaryKeyInfos() {
	List primaries = new ArrayList();
	int size = info_.size();
	for (int i = 0;i < size;i++) {
	    TColumnInfo info = (TColumnInfo)info_.get(i);
	    if (info.isPrimary()) {
		primaries.add(info);
	    }
	}
	TColumnInfo[] result = new TColumnInfo[primaries.size()];
	return ((TColumnInfo[])primaries.toArray(result));
    }
}
