/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.tmodel;

import java.util.*;
import jp.gr.java_conf.jaba2.datatype.ISQLDatatype;
import jp.gr.java_conf.jaba2.util.PropertyList;

/**
 * TColumnInfo
 *
 * @since   Feb. 18, 2000
 * @version Dec. 14, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class TColumnInfo {
    private String name_;
    private ISQLDatatype type_;
    private boolean primary_;
    private boolean unique_;
    private boolean notNull_;
    private PropertyList properties_ = new PropertyList();

    public TColumnInfo(String name, ISQLDatatype type) {
	name_ = name;
	type_ = type;
    }

    public final ISQLDatatype getSQLDatatype() {
	return (type_);
    }

    public final String getName() {
	return (name_);
    }

    public final boolean isPrimary() {
	return (primary_);
    }

    public final void setPrimary(boolean primary) {
	primary_ = primary;
    }
    
    public final boolean isUnique() {
	return (unique_);
    }

    public final void setUnique(boolean unique) {
	unique_ = unique;
    }

    public final boolean isNotNull() {
	return (notNull_);
    }

    public final void setNotNull(boolean notNull) {
	notNull_ = notNull;
    }

    public final void setProperty(String key, Object value) {
	properties_.put(key, value);
    }

    public final Object getProperty(String key) {
	return (properties_.get(key));
    }
}
