package jp.gr.java_conf.jaba2.text.updater.ruleR;

import org.w3c.dom.*;

/**
 * <b>Rule</b> is generated by Relaxer based on rule.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule label="rule">
 *   <tag/>
 *   <sequence>
 *     <element name="pattern" type="string"/>
 *     <ref label="replace"/>
 *   </sequence>
 * </elementRule>
 * 
 * <tag/>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule label="rule"&gt;
 *   &lt;tag/&gt;
 *   &lt;sequence&gt;
 *     &lt;element name="pattern" type="string"/&gt;
 *     &lt;ref label="replace"/&gt;
 *   &lt;/sequence&gt;
 * &lt;/elementRule&gt;
 * &lt;tag/&gt;
 * </pre>
 *
 * @version rule.rlx (Thu Nov 09 13:17:42 JST 2000)
 * @author  Relaxer 0.11.1b (by ASAMI@Yokohama)
 */
public class Rule implements java.io.Serializable {
    private String pattern_;
    private Replace replace_;

    /**
     * Creates a <code>Rule</code>.
     *
     */
    public Rule() {
    }

    /**
     * Creates a <code>Rule</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public Rule(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>Rule</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public Rule(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>Rule</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public Rule(Element element) {
        setup(element);
    }

    /**
     * Initializes the <code>Rule</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>Rule</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>Rule</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        IRuleFactory factory = RuleFactory.getFactory();
        RStack stack = new RStack(element);
        pattern_ = URelaxer.getElementPropertyAsString(stack.popElement());
        setReplace(factory.createReplace(stack));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("rule");
        int size;
        URelaxer.setElementPropertyByString(element, "pattern", this.pattern_);
        this.replace_.makeElement(element);
        parent.appendChild(element);
    }

    /**
     * Gets the String property <b>pattern</b>.
     *
     * @return String
     */
    public final String getPattern() {
        return (pattern_);
    }

    /**
     * Sets the String property <b>pattern</b>.
     *
     * @param pattern
     */
    public final void setPattern(String pattern) {
        this.pattern_ = pattern;
    }

    /**
     * Gets the Replace property <b>replace</b>.
     *
     * @return Replace
     */
    public final Replace getReplace() {
        return (replace_);
    }

    /**
     * Sets the Replace property <b>replace</b>.
     *
     * @param replace
     */
    public final void setReplace(Replace replace) {
        this.replace_ = replace;
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>Rule</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "rule")) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        child = target.popElement();
        if (child == null) {
            return (false);
        }
        if (!URelaxer.isTargetElement(child, "pattern")) {
            return (false);
        }
        if (!Replace.isMatchHungry(target)) {
            return (false);
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Rule</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Rule</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
