package jp.gr.java_conf.jaba2.text.updater.ruleR;

import org.w3c.dom.*;

/**
 * IRuleFactory is generated by Relaxer based on rule.rlx.
 *
 * @version rule.rlx (Thu Nov 09 13:17:43 JST 2000)
 * @author  Relaxer 0.11.1b (by ASAMI@Yokohama)
 */
public interface IRuleFactory {
    /**
     * Creates a <code>RuleSet</code>.
     *
     * @return RuleSet
     */
    RuleSet createRuleSet();

    /**
     * Creates a <code>Rule</code>.
     *
     * @return Rule
     */
    Rule createRule();

    /**
     * Creates a <code>Replace</code>.
     *
     * @return Replace
     */
    Replace createReplace();

    /**
     * Creates a <code>RuleSet</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return RuleSet
     */
    RuleSet createRuleSet(Document doc);

    /**
     * Creates a <code>Rule</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return Rule
     */
    Rule createRule(Document doc);

    /**
     * Creates a <code>Replace</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return Replace
     */
    Replace createReplace(Document doc);

    /**
     * Creates a <code>RuleSet</code> by the Element <code>element</code>.
     *
     * @param element
     * @return RuleSet
     */
    RuleSet createRuleSet(Element element);

    /**
     * Creates a <code>Rule</code> by the Element <code>element</code>.
     *
     * @param element
     * @return Rule
     */
    Rule createRule(Element element);

    /**
     * Creates a <code>Replace</code> by the Element <code>element</code>.
     *
     * @param element
     * @return Replace
     */
    Replace createReplace(Element element);

    /**
     * Creates a <code>RuleSet</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return RuleSet
     */
    RuleSet createRuleSet(RStack stack);

    /**
     * Creates a <code>Rule</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return Rule
     */
    Rule createRule(RStack stack);

    /**
     * Creates a <code>Replace</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return Replace
     */
    Replace createReplace(RStack stack);
}
