/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@AsamiOffice.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.jmodel.lang;

import java.util.*;

/**
 * LJClassifier
 *
 * @since   Jan. 17, 2000
 * @version Aug. 31, 2003
 * @author  ASAMI, Tomoharu (asami@AsamiOffice.com)
 */
public abstract class LJClassifier implements IAccessMode {
    private LJPackage package_;
    private Set importPackages_ = new TreeSet(); // List<String>
//    private List importPackages_ = new ArrayList(); // List<String>
    private String name_;
    private int access_;
    private String desc_;
    private String version_;
    private String author_;
    private String patchCode_;

    protected LJClassifier(String name, int access) {
	name_ = name;
	access_ = access;
    }

    public void setup(LJClassifier ljClassifier) {
	package_ = ljClassifier.package_;
	importPackages_.addAll(ljClassifier.importPackages_);
    }

    public void setupPackage(LJPackage ljpackage) {
	if (package_ != null) {
	    throw (new InternalError());
	}
	package_ = ljpackage;
    }

    public final void clearImportPackages() {
        importPackages_.clear();
    }        

    public final void setImportPackages(String[] names) {
        importPackages_.clear();
        addImportPackages(names);
    }

    public final void addImportPackages(String[] names) {
	for (int i = 0;i < names.length;i++) {
	    addImportPackage(names[i]);
	}
    }

    public final void addImportPackage(String name) {
	importPackages_.add(name);
    }

    public final String[] getImportPackages() {
	String[] packages = new String[importPackages_.size()];
	return ((String[])importPackages_.toArray(packages));
    }

    public final LJPackage getPackage() {
	return (package_);
    }

    public final String getName() {
	return (name_);
    }

    public final String getFullName() {
	if (package_ != null) {
	    return (package_.getName() + "." + name_);
	} else {
	    return (name_);
	}
    }

    public final int getAccessMode() {
	return (access_);
    }

    public final void setDescription(String desc) {
	desc_ = desc;
    }

    public final void setVersion(String version) {
	version_ = version;
    }

    public final void setAuthor(String author) {
	author_ = author;
    }

    public final void setPatchCode(String code) {
	patchCode_ = code;
    }

    public final String getPatchCode() {
	return (patchCode_);
    }

    public final String getDescription() {
	return (desc_);
    }

    public final String getAuthor() {
	return (author_);
    }

    public final String getVersion() {
	return (version_);
    }
}
