/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2003  ASAMI, Tomoharu (asami@AsamiOffice.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.j2fw.generator;

import java.util.*;
import java.io.*;
import jp.gr.java_conf.jaba2.io.UFile;
import jp.gr.java_conf.jaba2.io.UIO;

/**
 * LinkArtifact
 *
 * @since   Aug.  2, 1999
 * @version Oct. 19, 2003
 * @author  ASAMI, Tomoharu (asami@AsamiOffice.com)
 */
public class LinkArtifact extends GeneratorArtifact {
    public String from_;

    public LinkArtifact(String name, String from) {
        super(name);
        from_ = from;
    }

    public File makeFile(File dir) throws IOException {
        File to = new File(dir, name_);
        File from = new File(from_);
        if (!from.exists()) {
            return (null);
        }
        if (UFile.isIdentical(to, from)) {
            return (null);
        }
        if (from.lastModified() != to.lastModified() ||
            from.length() != to.length()) {

            UFile.copyFile(from, to);
            return (to);
        }
        return (null);
    }

    public void outputStream(OutputStream out) throws IOException {
        UIO.concatStreams(new FileInputStream(from_), out);
    }

    public byte[] getBytes() throws IOException {
        return (UIO.file2Bytes(from_));
    }
}
