package jp.gr.java_conf.jaba2.html;

import javax.swing.table.TableModel;
import javax.swing.tree.TreeModel;

/**
 * UHTML
 *
 * @since   Sep.  1, 1998
 * @version Nov. 20, 1998
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public final class UHTML {
    public static String tableModel2Table(
	TableModel model
    ) {
	return (tableModel2Table(model, null, null));
    }

    public static String tableModel2Table(
	TableModel model,
	String option
    ) {
	return (tableModel2Table(model, option, null));
    }

    public static String tableModel2Table(
	TableModel model,
	String option,
	String caption
    ) {
	StringBuffer buffer = new StringBuffer();
	int nRows = model.getRowCount();
	int nColumns = model.getColumnCount();
	buffer.append("<table");
	if (option != null) {
	    buffer.append(" ");
	    buffer.append(option);
	}
	buffer.append(">\n");
	// caption
	if (caption != null) {
	    buffer.append("<caption>");
	    buffer.append(caption);
	    buffer.append("</caption>\n");
	}
	// header
	buffer.append("<thead>\n");
	buffer.append("<tr>\n");
	for (int x = 0;x < nColumns;x++) {
	    buffer.append("<th>");
	    buffer.append(model.getColumnName(x));
	    buffer.append("</th>\n");
	}
	buffer.append("</tr>\n");
	buffer.append("</thead>\n");
	// body
	buffer.append("<tbody>\n");
	for (int y = 0;y < nRows;y++) {
	    buffer.append("<tr>\n");
	    for (int x = 0;x < nColumns;x++) {
		buffer.append("<td>");
		buffer.append(model.getValueAt(y, x));
		buffer.append("</td>\n");
	    }
	    buffer.append("</tr>\n");
	}
	buffer.append("</tbody>\n");
	//
	buffer.append("</table>\n");
	return (new String(buffer));
    }

    public static String treeModel2Ul(TreeModel model) {
	StringBuffer buffer = new StringBuffer();
	Object root = model.getRoot();
	buffer.append("<ul>\n");
	_handleNode(model, root, buffer);
	buffer.append("</ul>\n");
	return (new String(buffer));
    }

    public static String treeModel2UlOmitRoot(TreeModel model) {
	StringBuffer buffer = new StringBuffer();
	Object root = model.getRoot();
	buffer.append("<ul>\n");
	int nChildren = model.getChildCount(root);
	for (int i = 0;i < nChildren;i++) {
	    Object child = model.getChild(root, i);
	    _handleNode(model, child, buffer);
	}
	_handleNode(model, root, buffer);
	buffer.append("</ul>\n");
	return (new String(buffer));
    }

    protected static void _handleNode(
	TreeModel model,
	Object node,
	StringBuffer buffer
    ) {
	buffer.append("<li> ");
	buffer.append(node.toString());
	buffer.append("\n");
	if (model.isLeaf(node)) {
	    return;
	}
	buffer.append("<ul>\n");
	int nChildren = model.getChildCount(node);
	for (int i = 0;i < nChildren;i++) {
	    Object child = model.getChild(node, i);
	    _handleNode(model, child, buffer);
	}
	buffer.append("</ul>\n");
    }
}
