/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.dombus.generator;

import java.util.*;
import jp.gr.java_conf.jaba2.text.UString;
import jp.gr.java_conf.jaba2.parcel.IParcel;
import jp.gr.java_conf.jaba2.dombus.*;

/**
 * DOMBusGeneratorController
 *
 * @since   Aug. 23, 2000
 * @version Sep. 12, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class DOMBusGeneratorController extends AbstractDOMBusComponent {
    IDOMBusGenerator[] generators_;

    public boolean init() {
	IDOMBusParameter param = context_.getParameter();
	String[] generatorNames = param.getParameterAsStringList("generator");
	IDOMBusComponent[] components
	    = bus_.getComponents(IDOMBusGenerator.class);
	List list = new ArrayList();
	for (int i = 0;i < components.length;i++) {
	    IDOMBusGenerator generator = (IDOMBusGenerator)components[i];
	    if (UString.compareList(generator.getID(), generatorNames)) {
		list.add(generator);
	    }
	}
	generators_ = new IDOMBusGenerator[list.size()];
	generators_ = (IDOMBusGenerator[])list.toArray(generators_);
	return (false);
    }

    public Object fire(DOMBusSignal signal) {
	IParcel parcel = (IParcel)signal.getContent();
	for (int i = 0;i < generators_.length;i++) {
	    IDOMBusGenerator generator = generators_[i];
	    IParcel artifact = generator.generate(parcel);
	    _sendSignal("artifact", artifact);
	}
	return (null);
    }
}
