/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.dombus.config;

import jp.gr.java_conf.jaba2.text.UString;
import jp.gr.java_conf.jaba2.dombus.*;
import jp.gr.java_conf.jaba2.dombus.configRelaxer.*;

/**
 * DOMBusEventGuardPredicate
 *
 * @since   Mar. 29, 2000
 * @version Apr. 19, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class DOMBusEventGuardPredicate extends CEventGuardPredicate
    implements IDOMBusGuard {

    public boolean isAccept(DOMBusSignal signal) {
	String label = getLabel();
	if (!UString.isNull(label)) {
	    if (!label.equals(signal.getLabel())) {
		return (false);
	    }
	}
	String instanceOf = getInstanceof();
	if (!UString.isNull(instanceOf)) {
	    Object content = signal.getContent();
	    if (content == null) {
		return (false);
	    }
	    Class clazz = content.getClass();
	    if (!_isMatchedClass(clazz, instanceOf)) {
		return (false);
	    }
	}
	String from = getFrom();
	if (!UString.isNull(from)) {
	    if (!from.equals(signal.getFrom())) {
		return (false);
	    }
	}
	String to = getTo();
	if (!UString.isNull(to)) {
	    if (!to.equals(signal.getTo())) {
		return (false);
	    }
	}
	return (true);
    }

    private boolean _isMatchedClass(Class clazz, String targetName) {
	String className = clazz.getName();
	if (className.endsWith(targetName)) {
	    return (true);
	}
	Class[] interfaces = clazz.getInterfaces();
	for (int i = 0;i < interfaces.length;i++) {
	    if (_isMatchedClass(interfaces[i], targetName)) {
		return (true);
	    }
	}
	Class parent = clazz.getSuperclass();
	if (parent == null) {
	    return (false);
	}
	return (_isMatchedClass(parent, targetName));
    }
}
