/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.dombus;

import jp.gr.java_conf.jaba2.text.UString;
import jp.gr.java_conf.jaba2.dombus.configRelaxer.CSlot;
import jp.gr.java_conf.jaba2.dombus.configRelaxer.CContextRef;
import jp.gr.java_conf.jaba2.dombus.config.DOMBusPost;

/**
 * AbstractComponentSlot
 *
 * @since   Mar. 29, 2000
 * @version Apr. 12, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
abstract class AbstractComponentSlot
    implements IComponentSlot, IDOMBusConstants {

    protected IDOMBusComponent component_;
    protected IDOMBusGuard guard_;
    protected DOMBusPost post_;
    private String contextName_;
    private String contextRole_;

    public AbstractComponentSlot(
	IDOMBusComponent component,
	IDOMBusGuard guard
    ) {
	_init(component, guard, null, null, null);
    }

    public AbstractComponentSlot(
	IDOMBusComponent component,
	CSlot slot
    ) {
	CContextRef ref = slot.getContextRef();
	if (ref != null) {
	    String contextName = UString.checkNull(ref.getName());
	    String contextRole = UString.checkNull(ref.getRole());
	    _init(
		component,
		(IDOMBusGuard)slot.getGuard(),
		(DOMBusPost)slot.getPost(),
		contextName,
		contextRole
	    );
	} else {
	    _init(
		component,
		(IDOMBusGuard)slot.getGuard(),
		(DOMBusPost)slot.getPost(),
		null,
		null
	    );
	}
    }

    private void _init(
	IDOMBusComponent component,
	IDOMBusGuard guard,
	DOMBusPost post,
	String contextName,
	String contextRole
    ) {
	component_ = component;
	guard_ = guard;
	post_ = post;
	if (contextName == null) {
	    contextName_ = DEFAULT_CONTEXT_NAME;
	} else {
	    contextName_ = contextName;
	}
	contextRole_ = contextRole;
    }

    // Object
    public String toString() {
	return (component_.toString());
    }

    public IDOMBusComponent getComponent() {
	return (component_);
    }

    public String getContextName() {
	return (contextName_);
    }

    public String getContextRole() {
	return (contextRole_);
    }
}
