/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.datatype;

import jp.gr.java_conf.jaba2.datatype.java.JavaDatatype;

/**
 * UDatatype
 *
 * @since   Dec. 10, 2000
 * @version Dec. 10, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public final class UDatatype {
    public static IJavaDatatype getJavaDatatype(IXMLDatatype xmlType) {
	String xmlName = xmlType.getName();
	return (new JavaDatatype(_xml2Java(xmlName)));
    }

    private static Class _xml2Java(String xmlName) {
	if ("string".equals(xmlName)) {
	    return (String.class);
	} else if ("token".equals(xmlName)) {
	    return (String.class);
	} else if ("boolean".equals(xmlName)) {
	    return (boolean.class);
	} else if ("byte".equals(xmlName)) {
	    return (byte.class);
	} else if ("short".equals(xmlName)) {
	    return (short.class);
	} else if ("int".equals(xmlName)) {
	    return (int.class);
	} else if ("long".equals(xmlName)) {
	    return (long.class);
	} else if ("unsignedByte".equals(xmlName)) {
	    return (short.class);
	} else if ("unsignedShort".equals(xmlName)) {
	    return (int.class);
	} else if ("unsignedInt".equals(xmlName)) {
	    return (long.class);
	} else if ("unsignedLong".equals(xmlName)) {
	    return (java.math.BigInteger.class);
	} else if ("float".equals(xmlName)) {
	    return (float.class);
	} else if ("double".equals(xmlName)) {
	    return (double.class);
	} else if ("decimal".equals(xmlName)) {
	    return (java.math.BigDecimal.class);
	} else if ("timeInstant".equals(xmlName)) {
	    return (String.class);
	} else if ("timeDuration".equals(xmlName)) {
	    return (String.class);
	} else if ("recurringDuration".equals(xmlName)) {
	    return (String.class);
	} else if ("recurringInstant".equals(xmlName)) {
	    return (String.class);
	} else if ("recurringDate".equals(xmlName)) {
	    return (String.class);
	} else if ("recurringDay".equals(xmlName)) {
	    return (String.class);
	} else if ("binary".equals(xmlName)) {
	    return (byte[].class);
	} else if ("uriReference".equals(xmlName)) {
	    return (java.net.URL.class);
	} else if ("language".equals(xmlName)) {
	    return (java.util.Locale.class);
	} else if ("Name".equals(xmlName)) {
	    return (String.class);
	} else if ("QName".equals(xmlName)) {
	    return (String.class);
	} else if ("NCName".equals(xmlName)) {
	    return (String.class);
	} else if ("integer".equals(xmlName)) {
	    return (java.math.BigInteger.class);
	} else if ("nonNegativeInteger".equals(xmlName)) {
	    return (java.math.BigInteger.class);
	} else if ("positiveInteger".equals(xmlName)) {
	    return (java.math.BigInteger.class);
	} else if ("nonPositiveInteger".equals(xmlName)) {
	    return (java.math.BigInteger.class);
	} else if ("negativeInteger".equals(xmlName)) {
	    return (java.math.BigInteger.class);
	} else if ("date".equals(xmlName)) {
	    return (String.class);
	} else if ("time".equals(xmlName)) {
	    return (String.class);
	} else if ("timePeriod".equals(xmlName)) {
	    return (String.class);
	} else if ("date".equals(xmlName)) {
	    return (String.class);
	} else if ("month".equals(xmlName)) {
	    return (String.class);
	} else if ("year".equals(xmlName)) {
	    return (String.class);
	} else if ("century".equals(xmlName)) {
	    return (String.class);
	} else if ("recurringDate".equals(xmlName)) {
	    return (String.class);
	} else if ("recurringDay".equals(xmlName)) {
	    return (String.class);
	} else if ("CDATA".equals(xmlName)) {
	    return (String.class);
	} else if ("NMTOKEN".equals(xmlName)) {
	    return (String.class);
	} else if ("NMTOKENS".equals(xmlName)) {
	    return (String[].class); // XXX
	} else if ("ID".equals(xmlName)) {
	    return (String.class);
	} else if ("IDREF".equals(xmlName)) {
	    return (String.class);
	} else if ("IDREFS".equals(xmlName)) {
	    return (String[].class); // XXX
	} else if ("ENTITY".equals(xmlName)) {
	    return (String.class);
	} else if ("ENTITIES".equals(xmlName)) {
	    return (String[].class); // XXX
	} else if ("NOTATION".equals(xmlName)) {
	    return (String.class); // XXX
	} else {
	    throw (new InternalError(xmlName));
	}
    }

    public static IJavaDatatype getJavaDatatype(ISQLDatatype sqlType) {
	throw (new InternalError());
    }

    public static IXMLDatatype getXMLDatatype(IJavaDatatype javaType) {
	throw (new InternalError());
    }

    public static IXMLDatatype getXMLDatatype(ISQLDatatype sqlType) {
	throw (new InternalError());
    }

    public static ISQLDatatype getSQLDatatype(IJavaDatatype javaType) {
	throw (new InternalError());
    }

    public static ISQLDatatype getSQLDatatype(IXMLDatatype xmlType) {
	throw (new InternalError());
    }
}
