/*
 * The JabaJaba class library
 *  Copyright (C) 1997-1999  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.awt.model;

import java.awt.*;

/**
 * DragModel
 *
 * @since   Mar.  5, 1999
 * @version Mar. 26, 1999
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public abstract class AbstractDragModel implements DragModel {
    protected Component pane_;
    protected Dimension size_ = new Dimension(10, 10);
    protected Dimension offset_ = new Dimension(0, 0);

    // DragModel
    public void setPane(Component pane) {
	pane_ = pane;
    }

    // DragModel
    public Rectangle paint(Graphics g, Point point) {
	int x = point.x - offset_.width;
	int y = point.y - offset_.height;
	int width = size_.width;
	int height = size_.height;
	Graphics targetG = g.create(x, y, width, height);
	paint(targetG);
	return (new Rectangle(x, y, width, height));
    }

    public void paint(Graphics g) { // default implementation
	g.setColor(Color.black);
	g.drawRect(0, 0, size_.width - 1, size_.height - 1);
    }

    // DragModel
    public void setSize(Dimension size) {
	size_ = size;
    }

    // DragModel
    public void setOffset(Dimension offset) {
	offset_ = offset;
    }

    // DragModel
    public boolean moved(Point point) {
	return (false);
    }

    // DragModel
    public boolean dragged(Point point) {
	return (false);
    }
}
