/*
 * The JabaJaba class library
 *  Copyright (C) 1997-1999  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.awt.lwlayout;

import java.awt.Dimension;
import java.awt.Rectangle;
import jp.gr.java_conf.jaba2.awt.NullComponent;

/**
 * BorderMetaLayout
 *
 * @since   Dec. 29, 1998
 * @version Feb.  8, 1999
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class BorderMetaLayout extends AbstractMetaLayoutManager {
    protected LightWeightLayoutManager center_ = new NullLightWeightLayout();
    protected LightWeightLayoutManager north_ = new NullLightWeightLayout();
    protected LightWeightLayoutManager south_ = new NullLightWeightLayout();
    protected LightWeightLayoutManager east_ = new NullLightWeightLayout();
    protected LightWeightLayoutManager west_ = new NullLightWeightLayout();

    public void addLightWeightLayoutManager(
	LightWeightLayoutManager lwlayout,
	Object constraints
    ) {
	if (!(constraints instanceof String)) {
	    throw (new IllegalArgumentException(
		constraints.getClass().toString()));
	}
	String name = (String)constraints;
	if ("center".equals(name)) {
	    center_ = lwlayout;
	} else if ("north".equals(name)) {
	    north_ = lwlayout;
	} else if ("south".equals(name)) {
	    south_ = lwlayout;
	} else if ("east".equals(name)) {
	    east_ = lwlayout;
	} else if ("west".equals(name)) {
	    west_ = lwlayout;
	} else {
	    throw (new IllegalArgumentException(name));
	}
    }

    public Dimension preferredLayoutSize() {
	Dimension centerPref;
	Dimension northPref;
	Dimension southPref;
	Dimension eastPref;
	Dimension westPref;
	if (center_ == null) {
	    centerPref = new Dimension(0, 0);
	} else {
	    centerPref = center_.preferredLayoutSize();
	}
	if (north_ == null) {
	    northPref = new Dimension(0, 0);
	} else {
	    northPref = north_.preferredLayoutSize();
	}
	if (south_ == null) {
	    southPref = new Dimension(0, 0);
	} else {
	    southPref = south_.preferredLayoutSize();
	}
	if (east_ == null) {
	    eastPref = new Dimension(0, 0);
	} else {
	    eastPref = east_.preferredLayoutSize();
	}
	if (west_ == null) {
	    westPref = new Dimension(0, 0);
	} else {
	    westPref = west_.preferredLayoutSize();
	}
	int width = Math.max(northPref.width, southPref.width);
	width = Math.max(width,
			 eastPref.width + centerPref.width + westPref.width);
	int height = Math.max(eastPref.height, westPref.height);
	height = Math.max(height, centerPref.height);
	height += northPref.height + southPref.height;
	return (new Dimension(width, height));
    }

    public void layoutComponents(Dimension size) {
	// XXX : should handle gap (insets is handled by upper module)
	Rectangle centerBounds = new Rectangle();
	Rectangle northBounds = new Rectangle();
	Rectangle southBounds = new Rectangle();
	Rectangle eastBounds = new Rectangle();
	Rectangle westBounds = new Rectangle();

	Dimension westPrefSize = west_.preferredLayoutSize();
	Dimension eastPrefSize = east_.preferredLayoutSize();
	Dimension northPrefSize = north_.preferredLayoutSize();
	Dimension southPrefSize = south_.preferredLayoutSize();
	//// size
	// north
	northBounds.width = size.width;
	northBounds.height = northPrefSize.height;
	// south
	southBounds.width = size.width;
	southBounds.height = southPrefSize.height;
	// east
	eastBounds.width = eastPrefSize.width;
	eastBounds.height
	    = size.height - northBounds.height - southBounds.height;
	// west
	westBounds.width = westPrefSize.width;
	westBounds.height
	    = size.height - northBounds.height - southBounds.height;
	// center
	centerBounds.width = size.width - westBounds.width - eastBounds.width;
	centerBounds.height
	    = size.height - northBounds.height - southBounds.height;
	//// position
	// north
	northBounds.x = 0;
	northBounds.y = 0;
	// west
	westBounds.x = 0;
	westBounds.y = northBounds.height;
	// center
	centerBounds.x = westBounds.width;
	centerBounds.y = northBounds.height;
	// east
	eastBounds.x = centerBounds.x + centerBounds.width;
	eastBounds.y = northBounds.height;
	// south
	southBounds.x = 0;
	southBounds.y = centerBounds.y + centerBounds.height;

	north_.layoutComponents(northBounds);
	west_.layoutComponents(westBounds);
	center_.layoutComponents(centerBounds);
	east_.layoutComponents(eastBounds);
	south_.layoutComponents(southBounds);
    }
}
