/*
 * The JabaJaba class library
 *  Copyright (C) 1997-1998  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.awt.graph;

import java.util.*;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Point;
import java.awt.Graphics;
import java.awt.Color;
import javax.swing.*;
import jp.gr.java_conf.jaba2.awt.UAWT;

/**
 * GraphLink
 *
 * @since   Nov. 27, 1998
 * @version Dec. 15, 1998
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class GraphLink extends AbstractGraphObject {
    protected List leftNodes_ = new ArrayList(); // List<GrapNode>
    protected List rightNodes_ = new ArrayList(); // List<GrapNode>
    protected boolean lrDirection_ = false;
    protected boolean rlDirection_ = false;

    public GraphLink() {
    }

    public GraphLink(GraphModel model) {
	super(model);
    }

    // AbstractGraphObject
    public boolean isValidPosition(int x, int y) {
	return (false);
    }

    // JComponent
    public void paint(Graphics g) {
System.out.println("link paint");
	if (leftNodes_.size() == 0) {
	    return;
	}
	if (rightNodes_.size() == 0) {
	    return;
	}
	GraphNode left = (GraphNode)leftNodes_.get(0); // XXX
	GraphNode right = (GraphNode)rightNodes_.get(0); // XXX
	Rectangle leftBounds = left.getBounds();
	Rectangle rightBounds = right.getBounds();
//System.out.println("Link = " + getBounds());
//System.out.println(leftBounds + "-" + rightBounds);
	Point leftCenter = UAWT.calcCenter(leftBounds);
	Point rightCenter = UAWT.calcCenter(rightBounds);
	g.setColor(Color.black);
	g.drawLine(leftCenter.x, leftCenter.y, rightCenter.x, rightCenter.y);
//	g.drawLine(leftBounds.x, leftBounds.y, rightBounds.x, rightBounds.y);
    }

    public void addLeftNode(GraphNode node) {
	leftNodes_.add(node);
	node.addLink(this);
    }

    public void addRightNode(GraphNode node) {
	rightNodes_.add(node);
	node.addLink(this);
    }

    public void removeNode(GraphNode node) {
	leftNodes_.remove(node);
	rightNodes_.remove(node);
    }

    public GraphNode[] getLinkNodes(GraphNode node) {
	if (leftNodes_.contains(node)) {
	    GraphNode[] nodes = new GraphNode[rightNodes_.size()];
	    return ((GraphNode[])leftNodes_.toArray(nodes));
	} else if (rightNodes_.contains(node)) {
	    GraphNode[] nodes = new GraphNode[leftNodes_.size()];
	    return ((GraphNode[])rightNodes_.toArray(nodes));
	} else {
	    throw (new InternalError());
	}
    }

    public GraphNode[] getLinkNodes() {
	int nLefts = leftNodes_.size();
	int nRights = rightNodes_.size();
	GraphNode[] nodes = new GraphNode[nLefts + nRights];
	leftNodes_.toArray(nodes);
	Object[] rights = rightNodes_.toArray();
	System.arraycopy(rights, 0, nodes, nLefts, nRights);
	return (nodes);
    }

    public boolean isValid() {
	return (leftNodes_.size() > 0 && rightNodes_.size() > 0);
    }

    public Rectangle getRepaintBounds() {
	Rectangle bounds;
	int size;
	size = leftNodes_.size();
	if (size > 0) {
	    GraphNode node = (GraphNode)leftNodes_.get(0);
	    bounds = node.getBounds();
	    for (int i = 1;i < size;i++) {
		node = (GraphNode)leftNodes_.get(i);
		bounds = bounds.union(node.getBounds());
	    }
	    size = rightNodes_.size();
	    for (int i = 0;i < size;i++) {
		node = (GraphNode)rightNodes_.get(i);
		bounds = bounds.union(node.getBounds());
	    }
	} else {
	    size = rightNodes_.size();
	    if (size > 0) {
		GraphNode node = (GraphNode)leftNodes_.get(0);
		bounds = node.getBounds();
		for (int i = 1;i < size;i++) {
		    node = (GraphNode)rightNodes_.get(i);
		    bounds = bounds.union(node.getBounds());
		}
	    } else {
		return (new Rectangle(0, 0, 0, 0));
	    }
	}
	return (bounds);
    }
}
