/*
 * The JabaJaba class library
 *  Copyright (C) 1997-1999  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.awt.graph;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import jp.gr.java_conf.jaba2.awt.*;
import jp.gr.java_conf.jaba2.awt.graph.*;
import jp.gr.java_conf.jaba2.awt.lwlayout.*;

/**
 * GraphEditPanelBasePane
 *
 * @since   Mar.  1, 1999
 * @version Mar.  1, 1999
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class GraphEditNodePane extends JComponent implements Observer {
    public final static int MOVE_MODE = 1;
    public final static int LINK_MODE = 2;

    protected GraphModel model_;
/*    protected MouseEventHandler handler_; */
    protected int grid_ = 1;

    public GraphEditNodePane(GraphModel model) {
	setLayout(new ColumnLayout()); // XXX
	model_ = model;
	model_.addObserver(this);
/*	handler_ = new MouseEventHandler();*/
/*	addMouseListener(handler_);*/
/*	addMouseMotionListener(handler_);*/
    }

    // Observer
    public void update(Observable o, Object arg) {
	validate();
	repaint();
    }

    public void setMode(int mode) {
/*	handler_.setMode(mode);*/
    }

    public void setGrid(int grid) {
	grid_ = grid;
    }

    public int getGrid() {
	return (grid_);
    }

/*
    protected Component _findGraphNode(int x, int y) {
	return (_findGraphNode(this, x, y));
    }

    protected Component _findGraphNode(
	Container parent,
	int x,
	int y
    ) {
	Component[] comps = parent.getComponents();
	for (int i = 0;i < comps.length;i++) {
	    Component comp = comps[i];
	    Point pos = comp.getLocation();
	    int offx = x - pos.x;
	    int offy = y - pos.y;
	    
	    if (comp.contains(x - pos.x, y - pos.y)) {
		if (comp instanceof GraphNode) {
		    return (comp);
		} else if (comp instanceof Container) {
		    return (_findGraphNode((Container)comp, offx, offy));
		}
	    }
	}
	return (null);
    }

    protected Component _findActionGraphObject(int x, int y) {
	return (_findActionGraphObject(this, x, y));
    }

    protected Component _findActionGraphObject(
	Container parent,
	int x,
	int y
    ) {
	Component[] comps = parent.getComponents();
	for (int i = 0;i < comps.length;i++) {
	    Component comp = comps[i];
	    Point pos = comp.getLocation();
	    int offx = x - pos.x;
	    int offy = y - pos.y;
	    if (comp.contains(offx, offy)) {	    
		if (comp instanceof GraphObject) {
		    GraphObject gobj = (GraphObject)comp;
		    if (gobj.isValidPosition(offx, offy)) {
			if (gobj.isAction()) {
			    return (comp);
			}
			if (gobj.isRemovable()) {
			    return (comp);
			}
		    }
		} else if (comp instanceof Container) {
		    return (
			_findActionGraphObject((Container)comp, offx, offy)
		    );
		}
	    }
	}
	return (null);
    }

    protected Component _findGraphContainer(int x, int y) {
	return (_findGraphContainer(this, x, y));
    }

    protected Component _findGraphContainer(
	Container parent,
	int x,
	int y
    ) {
	Component[] comps = parent.getComponents();
	for (int i = 0;i < comps.length;i++) {
	    Component comp = comps[i];
	    if (comp instanceof GraphContainer) {
		GraphContainer gobj = (GraphContainer)comp;
		Point pos = comp.getLocation();
		int offx = x - pos.x;
		int offy = y - pos.y;
		if (comp.contains(offx, offy)) {
		    if (gobj.isValidPosition(offx, offy)) {
			if (gobj.isAction()) {
			    return (comp);
			}
			if (gobj.isRemovable()) {
			    return (comp);
			}
		    }
		}
	    } else if (comp instanceof Container) {
		int offx = x - comp.getX();
		int offy = y - comp.getY();
		_findGraphContainer((Container)comp, offx, offy);
	    }
	}
	return (null);
    }

    abstract class NodeHandler extends MouseAdapter
        implements MouseMotionListener {

	public void paint(Graphics g) {
	}

	public abstract void reset();
    }

    class MoveNodeHandler extends NodeHandler {
	Dimension offset_ = null;
	GraphNode node_ = null;
	GraphNode hilight_ = null;

	public void mousePressed(MouseEvent evt) {
	    mouseDragged(evt);
	}

	public void mouseReleased(MouseEvent evt) {
	    int x = evt.getX();
	    int y = evt.getY();
	    if (node_ != null) {
		Point pos = UAWT.calcGridedPosition(x, y, grid_);
		node_.setLocation(new Point(pos.x - offset_.width,
					    pos.y - offset_.height));
		node_.setSelected(false);
		repaint();
	    }
	    offset_ = null;
	    node_ = null;
	}

	public void mouseDragged(MouseEvent evt) {
	    int x = evt.getX();
	    int y = evt.getY();
	    if (node_ == null) {
		Component comp = _findGraphNode(x, y); // XXX
		if (comp == null) {
		    return;
		}
		if (!(comp instanceof GraphNode)) {
		    return;
		}
		Point point = comp.getLocation();
		offset_ = new Dimension(x - point.x, y - point.y);
		node_ = (GraphNode)comp;
		node_.setSelected(true);
		repaint();
	    } else {
//		Rectangle bounds = node_.getBounds();
		node_.setLocation(new Point(x - offset_.width,
					    y - offset_.height));
//		bounds.union(node_.getRepaintBounds());
//		repaint(bounds.x, bounds.y, bounds.width, bounds.height);
		repaint();	// XXX
	    }
	}

	public void mouseMoved(MouseEvent evt) {
	    boolean needRepaint = false;
	    try {
		int x = evt.getX();
		int y = evt.getY();
		if (hilight_ != null) {
		    hilight_.setHilight(false);
		    hilight_ = null;
		    needRepaint = true;
		}
		Component comp = _findGraphNode(x, y); // XXX
System.out.println("comp = " + comp);
		if (comp == null) {
		    return;
		}
		if (!(comp instanceof GraphNode)) {
		    return;
		}
		GraphNode node = (GraphNode)comp;
		node.setHilight(true);
		needRepaint = true;
		hilight_ = node;
	    } finally {
		if (needRepaint) {
		    repaint();
		}
	    }
	}

	public void reset() {
	    if (hilight_ != null) {
		hilight_.setHilight(false);
	    }
	    offset_ = null;
	    node_ = null;
	    hilight_ = null;
	    repaint();
	}
    }

    class LinkNodeHandler extends NodeHandler {
	Point start_ = null;
	Point end_ = null;
	GraphNode base_ = null;
	GraphNode hilight_ = null;

	public void mousePressed(MouseEvent evt) {
	    mouseDragged(evt);
	}

	public void mouseReleased(MouseEvent evt) {
	    if (start_ != null) {
		if (base_ != null) {
		    Component comp = _findGraphNode(evt.getX(), evt.getY());
		    if (comp != null && comp instanceof GraphNode) {
			GraphNode node = (GraphNode)comp;
			if (node != base_) {
			    GraphLink link = model_.createLink(base_, node);
			    model_.sync();
			}
		    }
		    base_.setSelected(false);
		}
		reset();
		repaint();
	    }
	}

	public void mouseDragged(MouseEvent evt) {
	    boolean needRepaint = false;
	    int x = evt.getX();
	    int y = evt.getY();
	    try {
		needRepaint = _processHilight(x, y);
		if (base_ == null) {
		    Component comp = _findGraphNode(x, y);
		    if (comp == null) {
			return;
		    }
		    if (!(comp instanceof GraphNode)) {
			return;
		    }
		    base_ = (GraphNode)comp;
		    base_.setSelected(true);
		    start_ = new Point(x, y);
		    end_ = start_;
		    needRepaint = true;
		} else {
		    end_ = new Point(x, y);
		    needRepaint = true;
		}
	    } finally {
		if (needRepaint) {
		    repaint();
		}
	    }
	}

	public void mouseMoved(MouseEvent evt) {
	    if (_processHilight(evt.getX(), evt.getY())) {
		repaint();
	    }
	}

	protected boolean _processHilight(int x, int y) {
	    Component comp = _findGraphNode(x, y); // XXX
	    if (hilight_ == null) {
		if (comp == null) {
		    return (false);
		}
		if (!(comp instanceof GraphNode)) {
		    return (false);
		}
		hilight_ = (GraphNode)comp;
		hilight_.setHilight(true);
		return (true);
	    } else {
		if (comp == null) {
		    hilight_.setHilight(false);
		    hilight_ = null;
		    return (true);
		}
		if (comp == hilight_) {
		    return (false);
		}
		hilight_.setHilight(false);
		if (comp instanceof GraphNode) {
		    hilight_ = (GraphNode)comp;
		    hilight_.setHilight(true);
		} else {
		    hilight_ = null;
		}
		return (true);
	    }
	}

	// NodeHandler
	public void paint(Graphics g) {
	    if (start_ != null) {
		g.setColor(Color.black);
		g.drawLine(start_.x, start_.y, end_.x, end_.y);
	    }
	}

	// NodeHandler
	public void reset() {
	    if (base_ != null) {
		base_.setHilight(false);
	    }
	    if (hilight_ != null) {
		hilight_.setHilight(false);
	    }
	    start_ = null;
	    end_ = null;
	    base_ = null;
	    hilight_ = null;
	}
    }

    class MouseEventHandler extends MouseAdapter
        implements MouseMotionListener {

	protected MoveNodeHandler moveHandler_;
	protected LinkNodeHandler linkHandler_;
	protected NodeHandler handler_;

	public MouseEventHandler() {
	    moveHandler_ = new MoveNodeHandler();
	    linkHandler_ = new LinkNodeHandler();
	    handler_ = moveHandler_;
	}

	public void paint(Graphics g) {
	    handler_.paint(g);
	}

	public void setMode(int mode) {
	    handler_.reset();
	    switch (mode) {

	    case MOVE_MODE:
		handler_ = moveHandler_;
		break;
	    case LINK_MODE:
		handler_ = linkHandler_;
		break;
	    default:
		throw (new InternalError());
	    }
	}

	public void mouseClicked(MouseEvent evt) {
//System.out.println(evt); // XXX
	}

	public void mouseReleased(MouseEvent evt) {
	    handler_.mouseReleased(evt);
	}

	public void mouseDragged(MouseEvent evt) {
	    handler_.mouseDragged(evt);
	}

	public void mouseMoved(MouseEvent evt) {
	    handler_.mouseMoved(evt);
	}

	public void mousePressed(MouseEvent evt) {
	    final int x = evt.getX();
	    final int y = evt.getY();
//System.out.println(evt);
	    if (evt.isPopupTrigger()) {
		Component comp = _findActionGraphObject(x, y);
		if (comp != null) {
		    final GraphObject gobj = (GraphObject)comp;
		    Action[] actions = gobj.getActions();
		    if (actions == null) {
			actions = new Action[0];
		    }
		    if (actions.length > 0 || gobj.isRemovable()) {
			JPopupMenu popup = new JPopupMenu("node operation");
			for (int i = 0;i < actions.length;i++) {
			    Action action = actions[i];
			    JMenuItem item = new JMenuItem(
				(String)action.getValue(Action.NAME)
			    );
			    item.addActionListener(action);
			    popup.add(item);
			}
			if (gobj.isRemovable()) {
			    if (actions.length > 0) {
				popup.addSeparator();
			    }
			    JMenuItem item = new JMenuItem("remove");
			    item.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent evt) {
				    model_.remove(gobj);
				    model_.sync();
				}
			    });
			    popup.add(item);
			}
			popup.show(evt.getComponent(), x, y);
		    }
		}
	    } else {
		handler_.mousePressed(evt);
	    }
	}
    }
*/
}
