package jp.gr.java_conf.jaba2.awt.explorer;

import java.lang.reflect.*;
import java.util.Observable;
import java.util.LinkedList;
import javax.swing.ListSelectionModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.table.TableModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.event.TableModelEvent;

/**
 * AbstractSummaryModel
 *
 * @since   May. 16, 1998
 * @version Nov. 20, 1998
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public abstract class AbstractSummaryModel
    extends AbstractTableModel implements SummaryModel
{
    protected ExplorerModel emodel_;
    protected TableModel model_ = new DefaultTableModel();
    protected TreePath current_ = null;
    protected ListSelectionModel smodel_;
    protected int sindex_ = NOSELECTION;
    protected TreeNode display_ = null;

    protected AbstractSummaryModel(ExplorerModel emodel) {
	emodel_ = emodel;
	smodel_ = new DefaultListSelectionModel() {
	    public void setSelectionInterval(int index0, int index1) {
		super.setSelectionInterval(index0, index1);
		if (display_ == null) {
		    return;
		}
		TreeNode node = display_.getChildAt(index0);
		// TreeNode2TreePath
		LinkedList list = new LinkedList();
		for (TreeNode n = node;n != null;n = n.getParent()) {
		    list.addFirst(n);
		}
		Object[] pathList = list.toArray();
		//
		setSelection(new TreePath(pathList));
	    }

	    public void addSelectionInterval(int index0, int index1) {
		// due to single selection mode
		// throw (new InternalError("need not to implement"));
		setSelectionInterval(index0, index1);
	    }
	};
    }

    // SummaryModel
    public ListSelectionModel refListSelectionModel() {
	return (smodel_);
    }

    // SummaryModel
    public int getSelectionIndex() {
	return (sindex_);
    }

    // Observer
    public void update(Observable o, Object arg) {
	if (o instanceof ExplorerModel) {
	    TreePath path = (TreePath)arg;
	    if (path.equals(current_)) {
		return;
	    }
	    current_ = path;
	    notifySelection(path);
	}
    }

    // SummaryModel
    public void setSelection(TreePath path) {
	emodel_.setSelection(path);
    }

    // SummaryModel
    public void notifySelection(TreePath path) {
	TreeNode node = (TreeNode)path.getLastPathComponent();
	if (isLeaf(node)) {
	    TreeNode parent = node.getParent();
	    _setTableModel(
		makeTableModel(parent),
		parent,
		parent.getIndex(node)
	    );
	} else {
	    _setTableModel(
		makeTableModel(node),
		node,
		NOSELECTION
	    );
	}
    }

    // SummaryModel
    public boolean isLeaf(TreeNode node) {
	return (node.getChildCount() == 0);
    }

    protected void _setTableModel(
	TableModel model,
	TreeNode displayNode,
	int selectionIndex
    ) {
	model_ = model;
	display_ = displayNode;
	sindex_ = selectionIndex;
	_fireTableStructureChanged();
    }

    protected void _fireTableStructureChanged() {
	try {
	    // JDK1.2 beta3
	    Class[] types = new Class[0];
	    Object[] args = new Object[0];
	    Method method = getClass().getMethod(
		"fireTableStructureChanged", types);
	    method.invoke(this, args);
	} catch (Exception e) {
	}
	try {
	    // JDK1.2 beta2
	    Class[] types = new Class[1];
	    types[0] = TableModelEvent.class;
	    Object[] args = new Object[1];
	    args[0] = new TableModelEvent(model_, -1);
	    Method method = getClass().getMethod(
		"fireTableChanged", types);
	    method.invoke(this, args);
	} catch (Exception e) {
	    // XXX
	    fireTableChanged(new TableModelEvent(model_, -1));
	}
    }

    // TableModel
    public int getRowCount() {
	return (model_.getRowCount());
    }

    // TableModel
    public int getColumnCount() {
	return (model_.getColumnCount());
    }

    // TableModel
    public Object getValueAt(int row, int column) {
	return (model_.getValueAt(row, column));
    }

    // AbstractTableModel
    public Class getColumnClass(int column) {
	return (model_.getColumnClass(column));
    }

    // AbstractTableModel
    public String getColumnName(int column) {
	return (model_.getColumnName(column));
    }
}
