package jp.gr.java_conf.jaba2.awt.explorer;

import java.util.Observable;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeNode;

/**
 * AbstractIndexModel
 *
 * @since   May. 16, 1998
 * @version Nov. 20, 1998
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public abstract class AbstractIndexModel
    extends DefaultTreeModel
    implements IndexModel {

    protected ExplorerModel emodel_;
    protected TreePath current_;

    protected AbstractIndexModel(ExplorerModel emodel, TreeNode root) {
	super(root);
	emodel_ = emodel;
    }

    protected AbstractIndexModel(
	ExplorerModel emodel,
	TreeNode root,
	boolean asksAllowsChildren
    ) {
	super(root, asksAllowsChildren);
	emodel_ = emodel;
    }

    // Observer
    public void update(Observable o, Object arg) {
	if (o instanceof ExplorerModel) {
	    TreePath path = (TreePath)arg;
	    if (path.equals(current_)) {
		return;
	    }
	    current_ = path;
	    notifySelection(path);
	}
    }

    // IndexModel
    public void setSelection(TreePath path) {
	emodel_.setSelection(path);
    }

    // SummaryModel
    public void notifySelection(TreePath path) {
    }
}
