package jp.gr.java_conf.jaba2.awt;

import java.lang.reflect.Method;
import java.util.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.*;
import javax.swing.*;
import jp.gr.java_conf.jaba2.util.Integrity;
import jp.gr.java_conf.jaba2.awt.*;

/**
 * WizardPanel
 *
 * @version Apr.  7, 1998
 * @version Nov. 20, 1998
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class WizardPanel extends CardPanel {
    public static interface Callback {
	public void enter(WizardPanel panel, int nth);
	public void leave(WizardPanel panel, int nth);
    }

    public static abstract class AbstractCallback implements Callback {
	public void enter(WizardPanel panel, int nth) {
	}

	public void leave(WizardPanel panel, int nth) {
	}
    }

    protected List panes_ = new ArrayList(); // List<Pane>
    protected Component[] panels_;
    protected Callback[] callbacks_;
    protected Integrity[] integrities_;
    protected ActionHandler[] handlers_;

    public WizardPanel() {
    }

    public void addPanels(Component[] panels) {
	panels_ = (Component[])panels.clone();
	callbacks_ = new Callback[panels.length];
	integrities_ = new Integrity[panels.length];
	handlers_ = new ActionHandler[panels.length];
	if (panels.length == 0) {
	    return;
	}
	if (panels.length == 1) {
	    Pane pane = _makeConfirmPane(panels[0], 0);
	    add(pane, 0);
	    if (panels[0] instanceof Callback) {
		setCallback(0, (Callback)panels[0]);
	    }
	    if (panels[0] instanceof Integrity) {
		setIntegrity(0, (Integrity)panels[0]);
	    }
	} else {
	    Pane pane;
	    pane = _makeFirstPane(panels[0]);
	    add(pane, 0);
	    if (panels[0] instanceof Callback) {
		setCallback(0, (Callback)panels[0]);
	    }
	    if (panels[0] instanceof Integrity) {
		setIntegrity(0, (Integrity)panels[0]);
	    }
	    for (int i = 1;i < panels.length - 1;i++) {
		pane = _makeProgressPane(panels[i], i);
		add(pane, i);
		if (panels[i] instanceof Callback) {
		    setCallback(i, (Callback)panels[i]);
		}
		if (panels[i] instanceof Integrity) {
		    setIntegrity(i, (Integrity)panels[i]);
		}
	    }
	    int index = panels.length - 1;
	    pane = _makeLastPane(panels[index], index);
	    add(pane, index);
	    if (panels[index] instanceof Callback) {
		setCallback(index, (Callback)panels[index]);
	    }
	    if (panels[index] instanceof Integrity) {
		setIntegrity(index, (Integrity)panels[index]);
	    }
	}
	raise(0);
    }

    public Component getPanel(int index) {
	return (panels_[index]);
    }

    public void setCallback(int index, Callback callback) {
	callbacks_[index] = callback;
    }

    public void setIntegrity(int index, Integrity integrity) {
	integrities_[index] = integrity;
	handlers_[index].setIntegrity(integrity);
	panels_[index].addPropertyChangeListener(handlers_[index]);
    }

    protected Pane _makeConfirmPane(Component panel, final int nth) {
	ActionHandler actions[] = new ActionHandler[2];
	actions[0] = new ActionHandler() {
	    public void actionPerformed(ActionEvent evt) {
		_moveDone(nth);
	    }
	};
	// actions[0].putValue(Action.NAME, "Done");
	_putValue(actions[0], Action.NAME, "Done");
	actions[1] = new ActionHandler() {
	    public void actionPerformed(ActionEvent evt) {
		_moveCancel(nth);
	    }
	};
	// actions[1].putValue(Action.NAME, "Cancel");
	_putValue(actions[1], Action.NAME, "Cancel");
	handlers_[0] = actions[0];
	return (new Pane(panel, new OptionBar(actions)));
    }

    protected Pane _makeFirstPane(Component panel) {
	ActionHandler actions[] = new ActionHandler[2];
	actions[0] = new ActionHandler() {
	    public void actionPerformed(ActionEvent evt) {
		_moveNext(0);
	    }
	};
	// actions[0].putValue(Action.NAME, "Next>>");
	_putValue(actions[0], Action.NAME, "Next>>");
	actions[1] = new ActionHandler() {
	    public void actionPerformed(ActionEvent evt) {
		_moveCancel(0);
	    }
	};
	// actions[1].putValue(Action.NAME, "Cancel");
	_putValue(actions[1], Action.NAME, "Cancel");
	handlers_[0] = actions[0];
	return (new Pane(panel, new OptionBar(actions)));
    }

    protected Pane _makeProgressPane(Component panel, final int nth) {
	ActionHandler actions[] = new ActionHandler[3];
	actions[0] = new ActionHandler() {
	    public void actionPerformed(ActionEvent evt) {
		_movePrev(nth);
	    }
	};
	// actions[0].putValue(Action.NAME, "<<Prev");
	_putValue(actions[0], Action.NAME, "<<Prev");
	actions[1] = new ActionHandler() {
	    public void actionPerformed(ActionEvent evt) {
		_moveNext(nth);
	    }
	};
	// actions[1].putValue(Action.NAME, "Next>>");
	_putValue(actions[1], Action.NAME, "Next>>");
	actions[2] = new ActionHandler() {
	    public void actionPerformed(ActionEvent evt) {
		_moveCancel(nth);
	    }
	};
	// actions[2].putValue(Action.NAME, "Cancel");
	_putValue(actions[2], Action.NAME, "Cancel");
	handlers_[nth] = actions[1];
	return (new Pane(panel, new OptionBar(actions)));
    }

    protected Pane _makeLastPane(Component panel, final int nth) {
	ActionHandler actions[] = new ActionHandler[3];
	actions[0] = new ActionHandler() {
	    public void actionPerformed(ActionEvent evt) {
		_movePrev(nth);
	    }
	};
	// actions[0].putValue(Action.NAME, "<<Prev");
	_putValue(actions[0], Action.NAME, "<<Prev");
	actions[1] = new ActionHandler() {
	    public void actionPerformed(ActionEvent evt) {
		_moveDone(nth);
	    }
	};
	// actions[1].putValue(Action.NAME, "Done");
	_putValue(actions[1], Action.NAME, "Done");
	actions[2] = new ActionHandler() {
	    public void actionPerformed(ActionEvent evt) {
		_moveCancel(nth);
	    }
	};
	// actions[2].putValue(Action.NAME, "Cancel");
	_putValue(actions[2], Action.NAME, "Cancel");
	handlers_[nth] = actions[1];
	return (new Pane(panel, new OptionBar(actions)));
    }

    protected void _moveDone(int nth) {
	if (callbacks_[nth] != null) {
	    callbacks_[nth].leave(WizardPanel.this, nth);
	}
	setActionCommand("done");
	_fireActionPerformed();
    }

    protected void _moveCancel(int nth) {
	if (callbacks_[nth] != null) {
	    callbacks_[nth].leave(WizardPanel.this, nth);
	}
	setActionCommand("cancel");
	_fireActionPerformed();
    }

    protected void _movePrev(int nth) {
	int prev = nth - 1;
	if (callbacks_[nth] != null) {
	    callbacks_[nth].leave(WizardPanel.this, nth);
	}
	if (callbacks_[prev] != null) {
	    callbacks_[prev].enter(WizardPanel.this, prev);
	}
	raise(prev);
    }

    protected void _moveNext(int nth) {
	int next = nth + 1;
	if (callbacks_[nth] != null) {
	    callbacks_[nth].leave(WizardPanel.this, nth);
	}
	if (callbacks_[next] != null) {
	    callbacks_[next].enter(WizardPanel.this, next);
	}
	raise(next);
    }

    protected class Pane extends Container {
	Pane(Component panel, OptionBar navi) {
	    setLayout(new DialogLayout());
	    Pane.this.add(panel, "view");
	    Pane.this.add(new JSeparator(), "separator");
	    Pane.this.add(navi, "indicator");
//	    setLayout(new BorderLayout());
//	    Pane.this.add(panel, BorderLayout.NORTH);
//	    Pane.this.add(new JSeparator(), BorderLayout.CENTER);
//	    Pane.this.add(navi, BorderLayout.SOUTH);
	}
    }

    protected class Navigator extends Container {
	Navigator(Action[] actions) {
	    ColumnLayout layout = new ColumnLayout(
		ColumnLayout.HBASE_RIGHT |
		ColumnLayout.VBASE_CENTER |
		ColumnLayout.WIDTH_EQUAL |
		ColumnLayout.HEIGHT_EQUAL |
		ColumnLayout.RESIZE_BOUND
	    );
	    layout.setOuterGap(0);
	    setLayout(layout);
	    for (int i = 0;i < actions.length;i++) {
		JButton button = new ActionButton(actions[i]);
		Navigator.this.add(button);
	    }
	}
    }

    abstract class ActionHandler extends AbstractAction
        implements PropertyChangeListener {

	protected Integrity integrity_ = null;

	public void setIntegrity(Integrity integrity) {
	    integrity_ = integrity;
System.out.println("setIntegrity in ActionHandler : " + integrity_.isComplete());
	    setEnabled(integrity_.isComplete());
	}

	// AbstractAction
	public boolean isEnabled() {
	    if (integrity_ == null) {
		return (true);
	    }
	    return (integrity_.isComplete());
	}

	// PropertyChangeListener
	public void propertyChange(PropertyChangeEvent evt) {
System.out.println("propertyChange in ActionHandler");
	    if (integrity_ != null) {
System.out.println("value : " + integrity_.isComplete());
		setEnabled(integrity_.isComplete());
	    }
	}
    }

    // test driver
    public static void main(String[] args) throws Exception {
	jp.gr.java_conf.jaba2.util.Debug.setClass("RowLayout");
	WizardPanel wizard = new WizardPanel();
	Component[] panels = new Component[4];
	panels[0] = new JButton("One");
	panels[1] = new JButton("Two");
	panels[2] = new JButton("Three");
	panels[3] = new JButton("Four");
	wizard.addPanels(panels);
	wizard.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent evt) {
		System.out.println("event = " + evt.getActionCommand());
	    }
	});
	new JTestFrame(wizard);
    }
}
