package jp.gr.java_conf.jaba2.awt;

import java.util.*;
import java.awt.Dialog;
import java.awt.FlowLayout;
import javax.swing.JFrame;
import javax.swing.JButton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * The <code>JDialogTestFrame</code> is a test driver for AWT dialogs.
 * Typical usage is shown under below.
 *
 * <pre>
 *     JDialogTestFrame frame = new JDialogTestFrame();
 *     frame.testDialog(new FileDialog(frame, "Test"));
 * </pre>
 *
 * In case of a modal dialog, you can get expected values via the dialog
 * in your ActionListener object.
 *
 * <pre>
 *     JDialogTestFrame frame = new JDialogTestFrame();
 *     final FileDialog dialog = new FileDialog(frame, "Test");
 *     frame.addActionListener(new ActionListener() {
 *          public void actionPerformed(ActionEvent evt) {
 *              System.out.println(dialog.getFile());
 *          }
 *     });
 *     frame.testDialog(dialog);
 * </pre>
 *
 * The JDialogTestFrame isn't MT-safe, because just test driver.
 *
 * @since   Jun. 18, 1998
 * @version Nov. 20, 1998
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class JDialogTestFrame extends JFrame {
    protected List listeners_ = new ArrayList();

    /**
     * Creates a <code>JDialogTestFrame</code> which shows a spcific AWT
     * dialog automatically.
     */
    public JDialogTestFrame() {
	_init("JDialogTestFrame");
    }

    /**
     * Creates a <code>JDialogTestFrame</code> which shows a spcific AWT
     * dialog automatically.
     *
     * @param title  frame title
     */
    public JDialogTestFrame(String title) {
	_init(title);
    }

    private void _init(String title) {
	setTitle(title);
	addWindowListener(new ExitWhenWindowClosing());
	getContentPane().setLayout(new FlowLayout());
    }

    /**
     * Tests a target dialog.
     *
     * @param dialog  a Dialog to test
     */
    public void testDialog(final Dialog dialog) {
	JButton button = new JButton("Push");
	button.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent evt) {
		dialog.show();
		_fireAction();
	    }
	});
	getContentPane().add(button);
	pack();
	show();
    }

    public void addActionListener(ActionListener listener) {
	listeners_.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
	listeners_.remove(listener);
    }

    protected void _fireAction() {
	ActionEvent evt = new ActionEvent(
	    this,
	    ActionEvent.ACTION_PERFORMED,
	    "dialog"
	);
	int size = listeners_.size();
	for (int i = 0;i < size;i++) {
	    ((ActionListener)listeners_.get(i)).actionPerformed(evt);
	}
    }

    // test driver
    public static void main(String[] args) {
	JDialogTestFrame frame = new JDialogTestFrame();
	final java.awt.FileDialog dialog
	    = new java.awt.FileDialog(frame, "Test");
	frame.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent evt) {
		System.out.println(dialog.getFile());
	    }
	});
	frame.testDialog(dialog);
    }
}
