package jp.gr.java_conf.jaba2.awt;

import java.awt.*;
import javax.swing.*;
import java.io.File;
import java.net.URL;

/**
 * The <code>ImageCanvas</code> is a simple canvas to display image.
 *
 * @since   Jun.  7, 1998
 * @version Nov. 20, 1998
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class ImageCanvas extends JComponent {
    /**
     * The image to display.
     */
    protected Image image_;
    /**
     * The image size. It's also used to be canvas size.
     */
    protected Dimension size_;

    /**
     * Creates a <code>ImageCanvas</code> to display the image of the resouce.
     *
     * @param name  the resource name of the image to display
     * @param base  the base object to get the class loader associated
     * the resource
     */
    public ImageCanvas(String name, Object base) {
	_init(UImage.getImage(name, base));
    }

    /**
     * Creates a <code>ImageCanvas</code> to display the image of the file.
     *
     * @param file  the filename of the image to display
     */
    public ImageCanvas(String file) {
	_init(UImage.getImage(file));
    }

    /**
     * Creates a <code>ImageCanvas</code> to display the image of the file.
     *
     * @param file  the <code>File</code> of the image to display
     */
    public ImageCanvas(File file) {
	_init(UImage.getImage(file));
    }

    /**
     * Creates a <code>ImageCanvas</code> to display the image of the file
     * specifiled by URL.
     *
     * @param name  the url of the image to display
     */
    public ImageCanvas(URL url) {
	_init(UImage.getImage(url));
    }

    /**
     * Creates a <code>ImageCanvas</code> to display the image of the file
     * specifiled by URL.
     *
     * @param image  the <code>Image</code> to display
     */
    public ImageCanvas(Image image) {
	_init(image);
    }

    public Dimension getPreferredSize() {
        return (new Dimension(size_));
    }
    
    public Dimension getMinimumSize() {
        return (new Dimension(size_));
    }

    public void update(Graphics g) {
	paint(g);
    }
    
    public void paint(Graphics g) {
	g.drawImage(image_, 0, 0, this);
    }

    private void _init(Image image) {
	UImage.waitLoading(image, this);
	image_ = image;
	size_ = new Dimension(image_.getWidth(this), image_.getHeight(this));
    }

    /**
     * Test driver
     */
    public static void main(String args[]) {
	String filename;
	if (args.length == 0) {
	    filename = "image.gif";
	} else {
	    filename = args[0];
	}
	ImageCanvas canvas = new ImageCanvas(new File(filename));
	new JTestFrame("ImageCanvas Test", canvas);
    }
}
