/*
 * SmartDoc : Ultimate document format based on XML
 *  Copyright (C) 1998-2003  ASAMI, Tomoharu (asami@XMLSmartDoc.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.SmartDoc.plain;

import java.util.*;
import java.io.*;
import jp.gr.java_conf.jaba2.util.ParameterInfo;
import jp.gr.java_conf.jaba2.util.AppParameterInfo;
import jp.gr.java_conf.jaba2.io.UURL;
import jp.gr.java_conf.jaba2.SmartDoc.*;

/**
 * PlainConfig
 *
 * @since   Jun. 21, 1999
 * @version Aug. 25, 2003
 * @author  ASAMI, Tomoharu (asami@XMLSmartDoc.org)
 */
public class PlainConfig extends AbstractSmartDocFormatConfig {
    private int layoutWidth_ = 70;
    private String keisenStyle_;
    private boolean useUnderlineHilight_;
    private String thickUnderline_;
    private String thinUnderline_;
    private String newline_;
    private String quotePrologue_;
    private String quoteEpilogue_;

    // SmartDocFormatConfig
    public void setup(SmartDocConfig config, String[] args)
	throws IOException {

	ParameterInfo info = new AppParameterInfo(
	    "jp.gr.java_conf.jaba2.SmartDoc",
	    args,
	    "jp.gr.java_conf.jaba2.SmartDoc.plain.PlainDefaults",
	    new File("SmartDoc.properties")
	);
	info.addPackage("jp.gr.java_conf.jaba2.SmartDoc.plain");
	info.addPackage("jp.gr.java_conf.jaba2.SmartDoc.plain.handler");
	_init(config, "plain", info);
	layoutWidth_ = info.getParameterAsInt("plain.width");
	keisenStyle_ = info.getParameterAsString("plain.keisen");
	useUnderlineHilight_ = info.getParameterAsBoolean("plain.underline");
	if ("jis".equals(keisenStyle_)) {
	    thickUnderline_ = "\u2501";
	    thinUnderline_ = "\u2500";
	} else {
	    thickUnderline_ = "=";
	    thinUnderline_ = "-";
	}
	String newline = info.getParameterAsString("plain.newline");
	if ("lf".equals(newline)) {
	    newline_ = "\n";
	} else if ("crlf".equals(newline)) {
	    newline_ = "\r\n";
	} else if ("cr".equals(newline)) {
	    newline_ = "\r";
	} else {
	    newline_ = "\n";
	}
	quotePrologue_ = info.getParameterAsString("plain.quotePrologue");
	quoteEpilogue_ = info.getParameterAsString("plain.quoteEpilogue");
	String quote = info.getParameterAsString("plain.quote");
	if (quotePrologue_ == null) {
	    quotePrologue_ = quote;
	}
	if (quoteEpilogue_ == null) {
	    quoteEpilogue_ = quote;
	}
    }

    // SmartDocFormatConfig
    public String getID() {
	return ("plain");
    }

    // SmartDocFormatConfig
    public String getName() {
	return ("Plain");
    }

    // SmartDocFormatConfig
    public String[] getImageCandidates() {
	return (new String[] { "gif", "jpeg", "png" });
    }

    public final int getLayoutWidth() {
	return (layoutWidth_);
    }

    public final String getKeisenStyle() {
	return (keisenStyle_);
    }

    public final String getThinUnderline() {
	if (!useUnderlineHilight_) {
	    return (null);
	} else {
	    return (thinUnderline_);
	}
    }

    public final String getThickUnderline() {
	if (!useUnderlineHilight_) {
	    return (null);
	} else {
	    return (thickUnderline_);
	}
    }

    public final String getNewline() {
	return (newline_);
    }

    public final String getQuotePrologue() {
	return (quotePrologue_);
    }

    public final String getQuoteEpilogue() {
	return (quoteEpilogue_);
    }
}
