package jp.gr.java_conf.jaba2.SmartDoc.normalizer.hilight;

import java.io.*;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>Syntax</b> is generated by Relaxer based on hilightData.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule label="syntax">
 *   <tag>
 *     <attribute name="name" required="true" type="string"/>
 *   </tag>
 *   <ref label="word" occurs="*"/>
 * </elementRule>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule label="syntax"&gt;
 *   &lt;tag&gt;
 *     &lt;attribute name="name" required="true" type="string"/&gt;
 *   &lt;/tag&gt;
 *   &lt;ref label="word" occurs="*"/&gt;
 * &lt;/elementRule&gt;
 * </pre>
 *
 * @version hilightData.rlx 1.0 (Wed May 08 06:33:10 JST 2002)
 * @author  Relaxer 0.17b (http://www.relaxer.org)
 */
public class Syntax implements java.io.Serializable {
    private String name_;
    // List<Word>
    private java.util.List word_ = new java.util.ArrayList();

    /**
     * Creates a <code>Syntax</code>.
     *
     */
    public Syntax() {
    }

    /**
     * Creates a <code>Syntax</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public Syntax(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>Syntax</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public Syntax(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>Syntax</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public Syntax(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>Syntax</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Syntax(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>Syntax</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Syntax(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>Syntax</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Syntax(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>Syntax</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Syntax(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>Syntax</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Syntax(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>Syntax</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Syntax(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>Syntax</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>Syntax</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>Syntax</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        name_ = URelaxer.getAttributePropertyAsString(element, "name");
        word_.clear();
        while (!stack.isEmptyElement()) {
            if (Word.isMatch(stack)) {
                addWord(new Word(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("syntax");
        int size;
        URelaxer.setAttributePropertyByString(element, "name", this.name_);
        size = this.word_.size();
        for (int i = 0;i < size;i++) {
            Word value = (Word)this.word_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>Syntax</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>Syntax</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Syntax</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Syntax</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Syntax</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Syntax</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>name</b>.
     *
     * @return String
     */
    public final String getName() {
        return (name_);
    }

    /**
     * Sets the String property <b>name</b>.
     *
     * @param name
     */
    public final void setName(String name) {
        this.name_ = name;
    }

    /**
     * Gets the Word property <b>word</b>.
     *
     * @return Word[]
     */
    public final Word[] getWord() {
        Word[] array = new Word[word_.size()];
        return ((Word[])word_.toArray(array));
    }

    /**
     * Sets the Word property <b>word</b>.
     *
     * @param word
     */
    public final void setWord(Word[] word) {
        this.word_.clear();
        this.word_.addAll(java.util.Arrays.asList(word));
    }

    /**
     * Sets the Word property <b>word</b>.
     *
     * @param word
     */
    public final void setWord(Word word) {
        this.word_.clear();
        this.word_.add(word);
    }

    /**
     * Adds the Word property <b>word</b>.
     *
     * @param word
     */
    public final void addWord(Word word) {
        this.word_.add(word);
    }

    /**
     * Gets number of the Word property <b>word</b>.
     *
     * @return int
     */
    public final int getWordCount() {
        return (word_.size());
    }

    /**
     * Gets the Word property <b>word</b> by index.
     *
     * @param index
     * @return Word
     */
    public final Word getWord(int index) {
        return ((Word)word_.get(index));
    }

    /**
     * Sets the Word property <b>word</b> by index.
     *
     * @param index
     * @param word
     */
    public final void setWord(int index, Word word) {
        this.word_.set(index, word);
    }

    /**
     * Remove the Word property <b>word</b> by index.
     *
     * @param index
     */
    public final void removeWord(int index) {
        word_.remove(index);
    }

    /**
     * Remove the Word property <b>word</b> by object.
     *
     * @param word
     */
    public final void removeWord(Word word) {
        this.word_.remove(word);
    }

    /**
     * Clear the Word property <b>word</b>.
     *
     */
    public final void clearWord() {
        word_.clear();
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<syntax");
        buffer.append(" name=\"");
        buffer.append(URelaxer.escapeAttrQuot(getName()));
        buffer.append("\"");
        buffer.append(">");
        size = this.word_.size();
        for (int i = 0;i < size;i++) {
            Word value = (Word)this.word_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</syntax>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<syntax");
        buffer.print(" name=\"");
        buffer.print(URelaxer.escapeAttrQuot(getName()));
        buffer.print("\"");
        buffer.print(">");
        size = this.word_.size();
        for (int i = 0;i < size;i++) {
            Word value = (Word)this.word_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</syntax>");
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getNameAsString() {
        return (URelaxer.getString(getName()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setNameByString(String string) {
        setName(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>Syntax</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "syntax")) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        while (!target.isEmptyElement()) {
            if (!Word.isMatchHungry(target)) {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Syntax</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Syntax</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
