/*
 * SmartDoc : Ultimate document format based on XML
 *  Copyright (C) 1998-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.SmartDoc.html3;

import java.util.*;
import java.io.*;
import jp.gr.java_conf.jaba2.util.ParameterInfo;
import jp.gr.java_conf.jaba2.util.AppParameterInfo;
import jp.gr.java_conf.jaba2.io.UURL;
import jp.gr.java_conf.jaba2.SmartDoc.*;

/**
 * HTML3Config
 *
 * @since   Apr. 24, 1999
 * @version Jul. 11, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class HTML3Config extends AbstractSmartDocFormatConfig {
    protected boolean strictDTD_;
    protected String[] imageCandidates_;

    // SmartDocFormatConfig
    public void setup(SmartDocConfig config, String[] args)
	throws IOException {

	ParameterInfo info = new AppParameterInfo(
	    "jp.gr.java_conf.jaba2.SmartDoc",
	    args,
	    "jp.gr.java_conf.jaba2.SmartDoc.html3.HTML3Defaults",
	    new File("SmartDoc.properties")
	);
	info.addPackage("jp.gr.java_conf.jaba2.SmartDoc.html3");
	info.addPackage("jp.gr.java_conf.jaba2.SmartDoc.html3.handler");
	strictDTD_ = info.getParameterAsBoolean("html3.strictDTD");
	imageCandidates_ = info.getParameterAsStringList("html3.imageFormat");
	_init(config, "html3", info);
    }

    // SmartDocFormatConfig
    public String getID() {
	return ("html3");
    }

    // SmartDocFormatConfig
    public String getName() {
	return ("HTML3.2");
    }

    // SmartDocFormatConfig
    public String[] getImageCandidates() {
	return (imageCandidates_);
    }

    public boolean isStrictDTD() {
	return (strictDTD_);
    }
}
