/*
 * SmartDoc : Ultimate document format based on XML
 *  Copyright (C) 1998-2003  ASAMI, Tomoharu (asami@XMLSmartDoc.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.SmartDoc.ant;

import java.util.*;
import java.io.*;
import java.net.*;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Parameter;
import jp.gr.java_conf.jaba2.text.UString;
import jp.gr.java_conf.jaba2.SmartDoc.SmartDoc;

/**
 * SmartDocTask
 *
 * @since   Sep. 20, 2003
 * @version Sep. 24, 2003
 * @author  ASAMI, Tomoharu (asami@XMLSmartDoc.org)
 */
public class SmartDocTask extends MatchingTask {
    private static final String STAMP_FILE = "SmartDoc.stamp";
    private File srcdir_;
    private File destdir_;
    private String policy_;
    private String propertyFileName_;
    private File propertyFile_;
    private Properties properties_;
    private int nCompiling_ = 0;

    public void init() {
        super.fileset.setIncludes("**/*.sdoc **/SmartDoc.properties");
    }

    public final void setSrcdir(File dir) {
        srcdir_ = dir;
        super.fileset.setDir(dir);
    }

    public final void setDestdir(File dir) {
        System.out.println(dir);
        destdir_ = dir;
    }

    public final void setPolicy(String policy) {
        policy_ = policy;
    }

    public final void setPropertyFile(String propertyFile) {
        System.out.println("x = " + propertyFile);
        propertyFileName_ = propertyFile;
    }

    public void execute() throws BuildException {
        if (propertyFileName_ != null) {
            System.out.println("xx = " + propertyFileName_);
            propertyFile_ = new File(srcdir_, propertyFileName_);
            try {
                properties_ = new Properties();
                properties_.load(new FileInputStream(propertyFile_));
            } catch (IOException e) {
                throw (new BuildException(e));
            }
        }
        DirectoryScanner scanner
            = super.fileset.getDirectoryScanner(super.project);
        scanner.scan();
        File baseDir = scanner.getBasedir();
        String[] files = scanner.getIncludedFiles();
        for (int i = 0;i < files.length;i++) {
            System.out.println(files[i]);
        }
        Map projects = getProjects_(files);
        try {
            Object[] entries = projects.entrySet().toArray();
            for (int i = 0;i < entries.length;i++) {
                executeDirectory_((Map.Entry)entries[i], baseDir);
            }
            markStamp_();
        } catch (IOException e) {
            throw (new BuildException(e));
        }
        report_();
    }

    private void executeDirectory_(
        Map.Entry entry,
        File baseDir
    ) throws IOException, BuildException {
        String dirName = (String)entry.getKey();
        List contents = (List)entry.getValue();
        Object[] fileNames = contents.toArray();
        String propertyFileName = getPropertyFileName_(fileNames);
        String sourceFileName
            = getSourceFileName_(fileNames, dirName, baseDir);
        String[] sdocFileNames = getSdocFileNames_(fileNames);
        System.out.println("<<<" + dirName + ">>>");
        System.out.println(propertyFileName);
        System.out.println(sourceFileName);
        for (int i = 0;i < sdocFileNames.length;i++) {
            String f = sdocFileNames[i];
            System.out.println("files = " + f);
        }
        if (true) {
            executeSdocFiles_(
                sdocFileNames,
                dirName,
                baseDir,
                propertyFileName
            );
        } else if (true) {
            throw (new UnsupportedOperationException());
        } else if (true) {
            throw (new UnsupportedOperationException());
        } else {
            throw (new BuildException());
        }
    }

    private void executeSdocFiles_(
        String[] fileNames,
        String dirName,
        File baseDir,
        String propertyFileName
    ) {
        for (int i = 0;i < fileNames.length;i++) {
            String fileName = fileNames[i];
            if (needBuild_(fileName, dirName, baseDir, propertyFileName)) {
                executeSdocFile_(fileName, dirName, baseDir, propertyFileName);
            }
        }
    }

    private void markStamp_() throws IOException {
        File stamp = new File(destdir_, STAMP_FILE);
        if (stamp.exists()) {
            stamp.delete();
        }
        stamp.createNewFile();
    }

    private boolean needBuild_(
        String fileName,
        String dirName,
        File baseDir,
        String propertyFileName
    ) {
        File from = new File(new File(baseDir, dirName), fileName);
        File reportFile = new File(destdir_, STAMP_FILE);
        if (!reportFile.exists()) {
            return (true);
        }
        return (from.lastModified() > reportFile.lastModified());
    }

    private boolean needBuild0_(
        String fileName,
        String dirName,
        File baseDir,
        String propertyFileName
    ) {
        File from = new File(new File(baseDir, dirName), fileName);
        File toDir = new File(destdir_, dirName);
        File reportFile = new File(toDir, "SmartDoc.README");
        if (!reportFile.exists()) {
            return (true);
        }
        return (from.lastModified() > reportFile.lastModified());
    }

    private void executeSdocFile_(
        String fileName,
        String dirName,
        File baseDir,
        String propertyFileName
    ) {        
        List list = new ArrayList();
        File from = new File(new File(baseDir, dirName), fileName);
        File toDir = new File(destdir_, dirName);
        System.out.println(from + " -> " + toDir);
        list.add("-dir:" + toDir.toString());
        setupProperties_(list, fileName, dirName, baseDir, propertyFileName);
        list.add(from.toString());
//        list.add("-sdoc.report");
        String[] args = new String[list.size()];
        args = (String[])list.toArray(args);
        for (int j = 0;j < args.length;j++) {
            String a = args[j];
            System.out.println(a);
        }
        executeSmartDoc_(args);
        countUp_();
    }

    private void setupProperties_(
        List list,
        String fileName,
        String dirName,
        File baseDir,
        String propertyFileName
    ) {
        int depth = calcDepth_(dirName);
        if (propertyFile_ != null) {
            list.add("-properties:" + propertyFile_.toString());
            String cssFile = (String)properties_.get("html4.css.url");
            if (!isUrl_(cssFile)) {
                list.add("-html4.css.url:" +
                         makeFileName_(depth, cssFile));
            }
        } else if (propertyFileName != null) {
            File propertyFile
                = new File(new File(baseDir, dirName), propertyFileName);
            list.add("-properties:" + propertyFile.toString());
        }
    }

    private boolean isUrl_(String name) {
        try {
            new URL(name);
            return (true);
        } catch (MalformedURLException e) {
            return (false);
        }
    }

    private int calcDepth_(String dirName) {
        if (dirName == null || "".equals(dirName)) {
            return (0);
        }
        int depth = 1;
        for (int index = dirName.indexOf(File.separator);
             index != -1;
             index = dirName.indexOf(File.separator, index + 1)) {
            depth++;
        }
        return (depth);
    }

    private String makeFileName_(int depth, String file) {
        if (depth < 0) {
            throw (new InternalError());
        }
        StringBuffer buffer = new StringBuffer();
        while (depth-- > 0) {
            buffer.append("../");
        }
        buffer.append(file);
        return (new String(buffer));
    }

    private void countUp_() {
        nCompiling_++;
    }

    private String getPropertyFileName_(Object[] fileNames) {
        for (int i = 0;i < fileNames.length;i++) {
            String fileName = (String)fileNames[i];
            if ("SmartDoc.properties".equals(fileName)) {
                return (fileName);
            }
        }
        return (null);
    }

    private String getSourceFileName_(
        Object[] fileNames,
        String dirName,
        File baseDir
    ) throws IOException {
        String propertyFileName = getPropertyFileName_(fileNames);
        if (propertyFileName == null) {
            return (null);
        }
        File propertyFile
            = new File(new File(baseDir, dirName), propertyFileName);
        InputStream in = null;
        BufferedInputStream bin = null;
        try {
            in = new FileInputStream(propertyFile);
            bin = new BufferedInputStream(in);
            Properties props = new Properties();
            props.load(bin);
            String source = (String)props.get("source");
            if (source == null || "".equals(source)) {
                return (null);
            } else {
                return (source);
            }
        } finally {
            if (bin != null) {
                try {
                    bin.close();
                } catch (IOException e) {
                }
            } else if (in != null) {
                try {
                    in.close();
                } catch (IOException e) {
                }
            }
        }
    }

    private String[] getSdocFileNames_(Object[] fileNames) {
        List list = new ArrayList();
        for (int i = 0;i < fileNames.length;i++) {
            String fileName = (String)fileNames[i];
            if (fileName.endsWith(".sdoc")) {
                list.add(fileName);
            }
        }
        String[] result = new String[list.size()];
        return ((String[])list.toArray(result));
    }

    private void executeSmartDoc_(String[] args) throws BuildException {
        try {
            SmartDoc engine = new SmartDoc(args);
            engine.start();
        } catch (Exception e) {
            throw (new BuildException(e));
        }
    }

    private void report_() {
        if (nCompiling_ == 0) {
            return;
        }
        System.out.print("Compiling ");
        switch (nCompiling_) {
        case 0:
            System.out.print("no files");
            break;
        case 1:
            System.out.print("one file");
            break;
        default:
            System.out.print(nCompiling_);
            System.out.print(" files");
        }
        System.out.print(" to ");
        System.out.print(destdir_);
        System.out.println(" .");
    }

    public Map getProjects_(String[] files) {
        Map map = new HashMap();
        for (int i = 0;i < files.length;i++) {
            String file = files[i];
            String container = UString.getContainerPathname(
                file,
                File.separator
            );
            if (container == null) {
                container = "";
            }
            String component = UString.getLastComponent(
                file,
                File.separator
            );
            List contents = (List)map.get(container);
            if (contents == null) {
                contents = new ArrayList();
                map.put(container, contents);
            }
            contents.add(component);
        }
        return (map);
    }
}
