<?xml version="1.0"?>
<!--
    sdoc2html.xsl

    since   : Jun. 15, 1999
    version : Nov. 10, 2000
    author  : ASAMI, Tomoharu (asami@zeomtech.com)
-->

<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  version="1.0">

  <xsl:output method="html"/>

  <xsl:template match="/doc">
    <HTML>
      <xsl:apply-templates/>
    </HTML>
  </xsl:template>

  <xsl:template match="head">
    <HEAD>
      <xsl:apply-templates select="title"/>
    </HEAD>
  </xsl:template>

  <xsl:template match="body">
    <BODY>
      <H1>
      <xsl:value-of select="/doc/head/title"/>
      </H1>
      <H2><xsl:text>Table of Contents</xsl:text></H2>

      <UL>
      <xsl:for-each select="section">
        <LI>
          <A>
            <xsl:attribute name="HREF">
              <xsl:text>#</xsl:text>
              <xsl:value-of select="id"/>
            </xsl:attribute>
            <xsl:value-of select="title"/>
          </A>
        </LI>
      </xsl:for-each>
      </UL>

      <xsl:apply-templates/>
    </BODY>
  </xsl:template>

  <xsl:template match="head/title">
    <TITLE><xsl:apply-templates/></TITLE>
  </xsl:template>

  <xsl:template match="section/title">
  </xsl:template>

  <xsl:template match="subsection/title">
  </xsl:template>

  <xsl:template match="subsubsection/title">
  </xsl:template>

  <xsl:template match="section">
    <H2>
      <xsl:attribute name="ID">
      <xsl:value-of select="@id"/>
      </xsl:attribute>
      <xsl:value-of select="title"/>
    </H2>
      <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="subsection">
    <H3><xsl:value-of select="title"/></H3>
      <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="subsubsection">
    <H4><xsl:value-of select="title"/></H4>
      <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="p">
    <P>
      <xsl:apply-templates/>
    </P>
  </xsl:template>

  <xsl:template match="ul">
    <UL>
      <xsl:apply-templates/>
    </UL>
  </xsl:template>

  <xsl:template match="ol">
    <OL>
      <xsl:apply-templates/>
    </OL>
  </xsl:template>

  <xsl:template match="li">
    <LI><xsl:apply-templates/></LI>
  </xsl:template>

  <xsl:template match="dl">
    <DL>
      <xsl:apply-templates/>
    </DL>
  </xsl:template>

  <xsl:template match="dt">
    <DT><xsl:apply-templates/></DT>
  </xsl:template>

  <xsl:template match="dd">
    <DD><xsl:apply-templates/></DD>
  </xsl:template>

  <xsl:template match="span">
    <SPAN><xsl:apply-templates/></SPAN>
  </xsl:template>

  <xsl:template match="div">
    <DIV><xsl:apply-templates/></DIV>
  </xsl:template>

</xsl:stylesheet>
