/*
 * RelaxerOrg class library
 *  Copyright (C) 2000,2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.taglib;

import java.io.*;
import java.net.URL;
import java.net.MalformedURLException;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import org.w3c.dom.Document;
import org.relaxer.beans.XSLTBean;

/**
 * XSLTBeanTag
 *
 * @since   Dec.  6, 2000
 * @version Aug. 23, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class XSLTBeanTag extends AbstractRelaxerTag {
    private XSLTBean xslt_ = new XSLTBean();

    public void setSourceUri(String uri) {
	xslt_.setSourceUri(_resolve(uri));
    }

    public void setXslUri(String uri) {
	xslt_.setXslUri(_resolve(uri));
    }

    public void setParams(String params) {
	xslt_.setParams(params);
    }

    protected int _doRelaxerEndTag() throws JspTagException {
	Document[] doc = findDocuments();
	if (doc != null) {
	    try {
		JspWriter out = pageContext.getOut();
		_transformDocuments(doc, out);
	    } catch (IOException e) {
		System.err.println("error : " + e);
	    }
	}
	return (EVAL_PAGE);
    }

    private void _transformDocuments(Document[] docs, JspWriter out)
	throws IOException {

	for (int i = 0;i < docs.length;i++) {
//System.out.println(i + ":" + org.relaxer.xml.UDOM.makeTextDocument(docs[i]));
	    _transformDocument(docs[i], out);
	}
    }

    private void _transformDocument(Document doc, JspWriter out)
	throws IOException {

	xslt_.setSourceDocument(doc);
	out.println(xslt_.transform());
    }

/*
    // AbstractRelaxerTag
    protected int _doRelaxerEndTag() throws JspTagException {
	Object rObject = findRObject();
System.out.println("XSLTBeanTag:" + rObject);
	if (rObject != null) {
	    try {
		JspWriter out = pageContext.getOut();
		if (rObject instanceof Object[]) {
		    _transformObjects((Object[])rObject, out);
		} else {
		    _transformObject(rObject, out);
		}
	    } catch (IOException e) {
		System.err.println("error : " + e);
	    }
	}
	return (EVAL_PAGE);
    }

    private void _transformObjects(Object[] objects, JspWriter out)
	throws IOException {

	for (int i = 0;i < objects.length;i++) {
	    _transformObject(objects[i], out);
	}
    }

    private void _transformObject(Object object, JspWriter out)
	throws IOException {

	xslt_.setSourceRObject(object);
	out.println(xslt_.transform());
    }
*/
}
