/*
 * RelaxerOrg class library
 *  Copyright (C) 2000-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.taglib;

import java.util.*;
import java.io.Serializable;
import java.lang.reflect.*;
import java.sql.SQLException;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import org.relaxer.beans.RJDBCDeleteBean;

/**
 * RJDBCDeleteBeanTag
 *
 * @since   Sep. 26, 2002
 * @version Sep. 27, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class RJDBCDeleteBeanTag extends AbstractRJDBCBeanTag {
    private String where_ = null;

    public RJDBCDeleteBeanTag() {
	_setup(new RJDBCDeleteBean());
    }

    public void setWhere(String where) {
	where_ = where;
    }

    protected int _doRelaxerStartTag() throws JspTagException {
	RJDBCDeleteBean bean = (RJDBCDeleteBean)bean_;
	try {
//ULog.log("start");
	    if (where_ != null) {
		bean.deleteRObjects(where_);
	    } else {
		bean.deleteRObjects();
	    }
//ULog.log("end");
	} catch (SQLException e) {
	    throw (new JspTagException(e.getMessage()));
	}
	return (EVAL_PAGE);
    }
}
