/*
 * RelaxerOrg class library
 *  Copyright (C) 2000-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.taglib;

import java.util.*;
import java.io.IOException;
import java.lang.reflect.*;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import org.relaxer.beans.DialogSpaceBean;

/**
 * CloseDialogTag
 *
 * @since   Jul. 13, 2001
 * @version Feb. 27, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class CloseDialogTag extends AbstractRelaxerTag {
    protected int _doRelaxerEndTag() throws JspException, JspTagException {
	try {
	    DialogSpaceBean dialog = _getDialogSpace();
	    _cleanupDialogSpace();
	    dialog.close();
	    return (super._doRelaxerEndTag());
	} catch (IOException e) {
	    throw (new JspTagException(e.getMessage()));
	}
    }

    protected final void _cleanupDialogSpace() throws JspTagException {
	_setJSPAttribute(getDialog(), null);
    }
}
