/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.tabular;

import java.util.*;
import org.w3c.dom.*;
import org.relaxer.util.D2Array;
import org.relaxer.xml.UDOM;

/**
 * UHTML
 *
 * @since   Jul. 11, 2001
 * @version Jul. 11, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public final class UHTML {
    public static boolean isMatch(Element element, String name) {
	String tagName = element.getTagName().toLowerCase();
	String localName = element.getLocalName();
	String namespaceURI = element.getNamespaceURI();
	if (namespaceURI != null) {
	    return ("http://www.w3.org/1999/xhtml".equals(namespaceURI) &&
		    localName.equals(name));
	} else {
	    return (tagName.equals(name));
	}
    }

    public static Element findTableElement(Element element) {
	if (isMatch(element, "table")) {
	    return (element);
	} else {
	    NodeList children = element.getChildNodes();
	    int size = children.getLength();
	    for (int i = 0;i < size;i++) {
		Node child = children.item(i);
		if (child instanceof Element) {
		    Element table = findTableElement((Element)child);
		    if (table != null) {
			return (table);
		    }
		}
	    }
	}
	return (null);
    }

    public static String[] table2Labels(Element table) {
	Element thead = getHTMLElement(table, "thead");
	if (thead == null) {
	    return (null);
	}
	Element tr = getHTMLElement(thead, "tr");
	if (tr == null) {
	    return (null);
	}
	Element[] tds = getHTMLElements(tr, "th");
	String[] labels = new String[tds.length];
	for (int i = 0;i < tds.length;i++) {
	    labels[i] = UDOM.makeTextDocument(tds[i]);
	}
	return (labels);
    }

    public static D2Array table2Array(Element table) {
	Element tbody = getHTMLElement(table, "tbody");
	if (tbody == null) {
	    tbody = table;
	}
	Element[] trs = getHTMLElements(tbody, "tr");
	D2Array array = new D2Array();
	for (int y = 0;y < trs.length;y++) {
	    Element[] tds = getHTMLElements(trs[y], "td");
	    for (int x = 0;x < tds.length;x++) {
		array.put(x, y, UDOM.makeTextDocument(tds[x]));
	    }
	}
	return (array);
    }

    public static Element getHTMLElement(Element element, String name) {
	NodeList children = element.getChildNodes();
	int size = children.getLength();
	for (int i = 0;i < size;i++) {
	    Node child = children.item(i);
	    if (child.getNodeType() == Node.ELEMENT_NODE) {
		Element childElement = (Element)child;
		if (isMatch(childElement, name)) {
		    return (childElement);
		}
	    }
	}
	return (null);
    }

    public static Element[] getHTMLElements(Element element, String name) {
	NodeList children = element.getChildNodes();
	List list = new ArrayList();
	int size = children.getLength();
	for (int i = 0;i < size;i++) {
	    Node child = children.item(i);
	    if (child.getNodeType() == Node.ELEMENT_NODE) {
		Element childElement = (Element)child;
		if (isMatch(childElement, name)) {
		    list.add(child);
		}
	    }
	}
	Element[] array = new Element[list.size()];
	return ((Element[])list.toArray(array));
    }
}
