/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.tabular;

import java.util.Hashtable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import javax.sql.XAConnection;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

/**
 * DataSourceTabular
 *
 * @since   Jul. 11, 2001
 * @version Aug. 15, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class DataSourceTabular extends TabularDecorator {
    private String uri_;
    private String sql_;
    private String username_ = null;
    private String password_ = null;
    private String nsInitial_ = null;
    private String nsRoot_ = null;

    public DataSourceTabular(
	String uri,
	String sql
    ) {
	uri_ = uri;
	sql_ = sql;
    }

    public void setUsername(String username, String password) {
	username_ = username;
	password_ = password;
    }

    public void setNamingInitialFactory(String initialFactory) {
	nsInitial_ = initialFactory;
    }

    public void setNamingRootUrl(String rootUrl) {
	nsRoot_ = rootUrl;
    }

    public void setup() throws NamingException, SQLException {
	Connection conn = _makeConnection();
	JDBCConnectionTabular tabular
	    = new JDBCConnectionTabular(conn, sql_);
	_setup(tabular);
	conn.close();
    }

    private Connection _makeConnection()
	throws NamingException, SQLException {

	Context ctx = _getInitialContext();
	Object object = ctx.lookup(uri_);
	if (object instanceof XADataSource) {
	    return (_getConnection((XADataSource)object));
	} else if (object instanceof DataSource) {
	    return (_getConnection((DataSource)object));
	} else {
	    throw (new SQLException("Invalid data source"));
	}
    }

    private Context _getInitialContext() throws NamingException {
	if (nsInitial_ == null && nsRoot_ == null) {
	    return (new InitialContext());
	}
	Hashtable env = new Hashtable();
	if (nsInitial_ != null) {
	    env.put(Context.INITIAL_CONTEXT_FACTORY, nsInitial_);
	}
	if (nsRoot_ != null) {
	    env.put(Context.PROVIDER_URL, nsRoot_);
	}
	return (new InitialContext(env));
    }

    private Connection _getConnection(XADataSource xads) throws SQLException {
	if (username_ != null && password_ != null) {
	    XAConnection xaconn = xads.getXAConnection(username_, password_);
	    return (xaconn.getConnection());
	} else {
	    XAConnection xaconn = xads.getXAConnection();
	    return (xaconn.getConnection());
	}
    }

    private Connection _getConnection(DataSource ds) throws SQLException {
	if (username_ != null && password_ != null) {
	    return (ds.getConnection(username_, password_));
	} else {
	    return (ds.getConnection());
	}
    }
}
