/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.parcel;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.MalformedURLException;
import org.xml.sax.SAXException;
import org.w3c.dom.Document;
import com.AsamiOffice.io.UIO;

/**
 * URIGadget
 *
 * @since   Aug. 24, 2000
 * @version Feb. 25, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class URIGadget extends AbstractGadget {
    private URL url_;

    public URIGadget(URL url) {
	url_ = url;
    }

    public URIGadget(String uri) throws MalformedURLException {
	url_ = new URL(uri);
    }

    public void write(OutputStream out) throws IOException { // XXX
	InputStream in = url_.openStream();
	UIO.concatStreams(in, out);
	in.close();
    }

    public byte[] getBytes() throws IOException { // XXX
	return (UIO.URL2Bytes(url_));
    }
}
