package org.relaxer.bus.rConfig;

import java.io.*;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>CPipe</b> is generated by Relaxer based on application.rxm.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule label="pipe">
 *   <tag>
 *     <attribute name="name" type="token"/>
 *   </tag>
 *   <sequence>
 *     <hedgeRef label="executable" occurs="*"/>
 *   </sequence>
 * </elementRule>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule label="pipe"&gt;
 *   &lt;tag&gt;
 *     &lt;attribute name="name" type="token"/&gt;
 *   &lt;/tag&gt;
 *   &lt;sequence&gt;
 *     &lt;hedgeRef label="executable" occurs="*"/&gt;
 *   &lt;/sequence&gt;
 * &lt;/elementRule&gt;
 * </pre>
 *
 * @version application.rxm (Wed Jan 02 23:42:46 JST 2002)
 * @author  Relaxer 0.15.1b (http://www.relaxer.org)
 */
public class CPipe implements java.io.Serializable, IRVisitable, IRNode, ICExecutableChoice, ICBusChoice {
    private String name_;
    // List<ICExecutableChoice>
    private java.util.List executable_ = new java.util.ArrayList();
    private IRNode parentRNode_;

    /**
     * Creates a <code>CPipe</code>.
     *
     */
    public CPipe() {
    }

    /**
     * Creates a <code>CPipe</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public CPipe(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>CPipe</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public CPipe(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>CPipe</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public CPipe(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>CPipe</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public CPipe(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>CPipe</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public CPipe(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>CPipe</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public CPipe(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>CPipe</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public CPipe(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>CPipe</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public CPipe(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>CPipe</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public CPipe(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>CPipe</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>CPipe</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>CPipe</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        name_ = URelaxer.getAttributePropertyAsString(element, "name");
        executable_.clear();
        while (!stack.isEmptyElement()) {
            if (CComponent.isMatch(stack)) {
                addExecutable(new CComponent(stack));
            } else if (CPipe.isMatch(stack)) {
                addExecutable(new CPipe(stack));
            } else if (CBus.isMatch(stack)) {
                addExecutable(new CBus(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("pipe");
        int size;
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        size = this.executable_.size();
        for (int i = 0;i < size;i++) {
            ICExecutableChoice value = (ICExecutableChoice)this.executable_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>CPipe</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>CPipe</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>CPipe</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>CPipe</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>CPipe</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>CPipe</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>name</b>.
     *
     * @return String
     */
    public final String getName() {
        return (name_);
    }

    /**
     * Sets the String property <b>name</b>.
     *
     * @param name
     */
    public final void setName(String name) {
        this.name_ = name;
    }

    /**
     * Gets the ICExecutableChoice property <b>executable</b>.
     *
     * @return ICExecutableChoice[]
     */
    public final ICExecutableChoice[] getExecutable() {
        ICExecutableChoice[] array = new ICExecutableChoice[executable_.size()];
        return ((ICExecutableChoice[])executable_.toArray(array));
    }

    /**
     * Sets the ICExecutableChoice property <b>executable</b>.
     *
     * @param executable
     */
    public final void setExecutable(ICExecutableChoice[] executable) {
        this.executable_.clear();
        this.executable_.addAll(java.util.Arrays.asList(executable));
        for (int i = 0;i < executable.length;i++) {
            executable[i].setParentRNode(this);
        }
    }

    /**
     * Sets the ICExecutableChoice property <b>executable</b>.
     *
     * @param executable
     */
    public final void setExecutable(ICExecutableChoice executable) {
        this.executable_.clear();
        this.executable_.add(executable);
        if (executable != null) {
            executable.setParentRNode(this);
        }
    }

    /**
     * Adds the ICExecutableChoice property <b>executable</b>.
     *
     * @param executable
     */
    public final void addExecutable(ICExecutableChoice executable) {
        this.executable_.add(executable);
        if (executable != null) {
            executable.setParentRNode(this);
        }
    }

    /**
     * Gets number of the ICExecutableChoice property <b>executable</b>.
     *
     * @return int
     */
    public final int getExecutableCount() {
        return (executable_.size());
    }

    /**
     * Gets the ICExecutableChoice property <b>executable</b> by index.
     *
     * @param index
     * @return ICExecutableChoice
     */
    public final ICExecutableChoice getExecutable(int index) {
        return ((ICExecutableChoice)executable_.get(index));
    }

    /**
     * Sets the ICExecutableChoice property <b>executable</b> by index.
     *
     * @param index
     * @param executable
     */
    public final void setExecutable(int index, ICExecutableChoice executable) {
        this.executable_.set(index, executable);
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<pipe");
        if (name_ != null) {
            buffer.append(" name=\"");
            buffer.append(URelaxer.escapeAttrQuot(getName()));
            buffer.append("\"");
        }
        buffer.append(">");
        size = this.executable_.size();
        for (int i = 0;i < size;i++) {
            ICExecutableChoice value = (ICExecutableChoice)this.executable_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</pipe>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<pipe");
        if (name_ != null) {
            buffer.print(" name=\"");
            buffer.print(URelaxer.escapeAttrQuot(getName()));
            buffer.print("\"");
        }
        buffer.print(">");
        size = this.executable_.size();
        for (int i = 0;i < size;i++) {
            ICExecutableChoice value = (ICExecutableChoice)this.executable_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</pipe>");
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getNameAsString() {
        return (URelaxer.getString(getName()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setNameByString(String string) {
        setName(string);
    }

    /**
     * Accepts the Visitor for enter behavior.
     *
     * @param visitor
     * @return boolean
     */
    public boolean enter(IRVisitor visitor) {
        return (visitor.enter(this));
    }

    /**
     * Accepts the Visitor for leave behavior.
     *
     * @param visitor
     */
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode getParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void setParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] getRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(executable_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>CPipe</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "pipe")) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        while (!target.isEmptyElement()) {
            if (CComponent.isMatchHungry(target)) {
            } else if (CPipe.isMatchHungry(target)) {
            } else if (CBus.isMatchHungry(target)) {
            } else {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>CPipe</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>CPipe</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
