/*
 * RelaxerOrg class library
 *  Copyright (C) 2000-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.beans;

import java.util.*;
import java.io.Serializable;
import java.lang.reflect.*;
import java.sql.SQLException;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import org.w3c.dom.Document;

/**
 * RJDBCUpdateBean
 *
 * @since   Feb.  1, 2001
 * @version Sep. 10, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class RJDBCUpdateBean extends AbstractRJDBCBean {
    public void updateRObject(Object rObject) throws SQLException {
	Object handle = _makeHandle();
	_updateObject(handle, rObject);
	_closeHandle(handle);
    }

    public void updateRObjects(Object[] rObjects) throws SQLException {
	Object handle = _makeHandle();
	_updateObjects(handle, rObjects);
	_closeHandle(handle);
    }

    private void _updateObject(
	Object handle,
	Object rObject
    ) throws SQLException {
	try {
	    Class[] types = { rObject.getClass() };
	    Method method = handle.getClass().getMethod("update", types);
	    Object[] params = { rObject };
	    method.invoke(handle, params);
	} catch (IllegalAccessException e) {
	    throw (_makeSQLException(e));
	} catch (NoSuchMethodException e) {
	    throw (_makeSQLException(e));
	} catch (InvocationTargetException e) {
	    throw (_makeSQLException(e));
	} 
    }

    private void _updateObjects(
	Object handle,
	Object[] rObjects
    ) throws SQLException {
//	org.relaxer.monitor.ULog.setDebug(true);
	try {
	    int length = Array.getLength(rObjects);
	    if (length == 0) {
		return;
	    }
	    Object firstElement = Array.get(rObjects, 0);
	    Class type = firstElement.getClass();
	    Object array = Array.newInstance(type, length);
	    System.arraycopy(rObjects, 0, array, 0, length);
	    Class[] types = { array.getClass() };
	    Method method = handle.getClass().getMethod("update", types);
	    Object[] params = { array };
	    method.invoke(handle, params);
	} catch (IllegalAccessException e) {
//ULog.log(e);
	    throw (_makeSQLException(e));
	} catch (NoSuchMethodException e) {
//ULog.log(e);
	    throw (_makeSQLException(e));
	} catch (InvocationTargetException e) {
//ULog.log(e);
	    throw (_makeSQLException(e));
	} 
    }

    public void updateDocument(Document doc) throws SQLException {
	Object handle = _makeHandle();
	_updateDocument(handle, doc);
	_closeHandle(handle);
    }

    public void updateDocuments(Document[] docs) throws SQLException {
	Object handle = _makeHandle();
	_updateDocuments(handle, docs);
	_closeHandle(handle);
    }

    private void _updateDocument(
	Object handle,
	Document doc
    ) throws SQLException {
	try {
	    Class[] types = { Document.class };
	    Method method = handle.getClass().getMethod("update", types);
	    Object[] params = { doc };
	    method.invoke(handle, params);
	} catch (IllegalAccessException e) {
//ULog.log(e);
	    throw (_makeSQLException(e));
	} catch (NoSuchMethodException e) {
//ULog.log(e);
	    throw (_makeSQLException(e));
	} catch (InvocationTargetException e) {
//ULog.log(e);
	    throw (_makeSQLException(e));
	} 
    }

    private void _updateDocuments(
	Object handle,
	Document[] docs
    ) throws SQLException {
//	org.relaxer.monitor.ULog.setDebug(true);
	try {
	    int length = Array.getLength(docs);
	    if (length == 0) {
		return;
	    }
	    Class[] types = { docs.getClass() };
	    Method method = handle.getClass().getMethod("update", types);
	    Object[] params = { docs };
	    method.invoke(handle, params);
	} catch (IllegalAccessException e) {
//ULog.log(e);
	    throw (_makeSQLException(e));
	} catch (NoSuchMethodException e) {
//ULog.log(e);
	    throw (_makeSQLException(e));
	} catch (InvocationTargetException e) {
//ULog.log(e);
	    throw (_makeSQLException(e));
	} 
    }
}
