/*
 * RelaxerOrg class library
 *  Copyright (C) 2000,2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.beans;

import java.util.*;
import java.io.Serializable;
import java.lang.reflect.*;
import java.sql.SQLException;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;

/**
 * RJDBCSelectBean
 *
 * @since   Mar.  4, 2001
 * @version Jun. 10, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class RJDBCSelectBean extends AbstractRJDBCBean {
    public Object[] selectRObjects() throws SQLException {
	Object handle = _makeHandle();
	Object[] objects = _selectObjects(handle);
	_closeHandle(handle);
	return (objects);
    }

    public Object[] selectRObjects(String where) throws SQLException {
	Object handle = _makeHandle();
	Object[] objects = _selectObjects(handle, where);
	_closeHandle(handle);
	return (objects);
    }

    private Object[] _selectObjects(
	Object handle
    ) throws SQLException {
//ULog.log("selectObjects:" + handle);
	try {
	    Class[] types = {};
	    Method method = handle.getClass().getMethod("select", types);
	    Object[] params = {};
	    return ((Object[])method.invoke(handle, params));
//ULog.log("selectObjects: method = " + method);
//try {
//} catch (Exception e) {
//    ULog.log(e);
//    throw (new SQLException(e.getMessage()));
//}
	} catch (IllegalAccessException e) {
	    throw (_makeSQLException(e));
	} catch (NoSuchMethodException e) {
	    throw (_makeSQLException(e));
	} catch (InvocationTargetException e) {
	    throw (_makeSQLException(e));
	} 
    }

    private Object[] _selectObjects(
	Object handle,
	String where
    ) throws SQLException {
	try {
	    Class[] types = { String.class };
	    Method method = handle.getClass().getMethod("select", types);
	    Object[] params = { where };
	    return ((Object[])method.invoke(handle, params));
	} catch (IllegalAccessException e) {
	    throw (_makeSQLException(e));
	} catch (NoSuchMethodException e) {
	    throw (_makeSQLException(e));
	} catch (InvocationTargetException e) {
	    throw (_makeSQLException(e));
	} 
    }
}
