package org.relaxer.auth.rAccount;

import java.io.*;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>RAccount</b> is generated by Relaxer based on account.rng.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="account">
 *   <attribute java:mapKey="true" name="name" sql:primary="true">
 *     <data type="token"/>
 *   </attribute>
 *   <attribute name="password">
 *     <data type="token"/>
 *   </attribute>
 *   <zeroOrMore>
 *     <ref name="addOnInfo"/>
 *   </zeroOrMore>
 * </element>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;element name="account"&gt;
 *   &lt;attribute java:mapKey="true" name="name" sql:primary="true"&gt;
 *     &lt;data type="token"/&gt;
 *   &lt;/attribute&gt;
 *   &lt;attribute name="password"&gt;
 *     &lt;data type="token"/&gt;
 *   &lt;/attribute&gt;
 *   &lt;zeroOrMore&gt;
 *     &lt;ref name="addOnInfo"/&gt;
 *   &lt;/zeroOrMore&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @version account.rng (Sun Sep 08 11:37:40 JST 2002)
 * @author  Relaxer 0.17b (http://www.relaxer.org)
 */
public class RAccount implements java.io.Serializable {
    private String name_;
    private String password_;
    // List<RAddOnInfo>
    private java.util.List addOnInfo_ = new java.util.ArrayList();
    private Element xmlElement;

    /**
     * Creates a <code>RAccount</code>.
     *
     */
    public RAccount() {
    }

    /**
     * Creates a <code>RAccount</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public RAccount(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>RAccount</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public RAccount(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>RAccount</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public RAccount(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>RAccount</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RAccount(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>RAccount</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RAccount(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>RAccount</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RAccount(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>RAccount</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RAccount(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>RAccount</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RAccount(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>RAccount</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RAccount(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>RAccount</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>RAccount</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>RAccount</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        xmlElement = element;
        RStack stack = new RStack(element);
        name_ = URelaxer.getAttributePropertyAsString(element, "name");
        password_ = URelaxer.getAttributePropertyAsString(element, "password");
        addOnInfo_.clear();
        while (!stack.isEmptyElement()) {
            if (RAddOnInfo.isMatch(stack)) {
                addAddOnInfo(new RAddOnInfo(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("account");
        int size;
        URelaxer.setAttributePropertyByString(element, "name", this.name_);
        URelaxer.setAttributePropertyByString(element, "password", this.password_);
        size = this.addOnInfo_.size();
        for (int i = 0;i < size;i++) {
            RAddOnInfo value = (RAddOnInfo)this.addOnInfo_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>RAccount</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>RAccount</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>RAccount</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>RAccount</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>RAccount</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>RAccount</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>name</b>.
     *
     * @return String
     */
    public final String getName() {
        return (name_);
    }

    /**
     * Sets the String property <b>name</b>.
     *
     * @param name
     */
    public final void setName(String name) {
        this.name_ = name;
    }

    /**
     * Gets the String property <b>password</b>.
     *
     * @return String
     */
    public final String getPassword() {
        return (password_);
    }

    /**
     * Sets the String property <b>password</b>.
     *
     * @param password
     */
    public final void setPassword(String password) {
        this.password_ = password;
    }

    /**
     * Gets the RAddOnInfo property <b>addOnInfo</b>.
     *
     * @return RAddOnInfo[]
     */
    public final RAddOnInfo[] getAddOnInfo() {
        RAddOnInfo[] array = new RAddOnInfo[addOnInfo_.size()];
        return ((RAddOnInfo[])addOnInfo_.toArray(array));
    }

    /**
     * Sets the RAddOnInfo property <b>addOnInfo</b>.
     *
     * @param addOnInfo
     */
    public final void setAddOnInfo(RAddOnInfo[] addOnInfo) {
        this.addOnInfo_.clear();
        for (int i = 0;i < addOnInfo.length;i++) {
            addAddOnInfo(addOnInfo[i]);
        }
    }

    /**
     * Sets the RAddOnInfo property <b>addOnInfo</b>.
     *
     * @param addOnInfo
     */
    public final void setAddOnInfo(RAddOnInfo addOnInfo) {
        this.addOnInfo_.clear();
        addAddOnInfo(addOnInfo);
    }

    /**
     * Adds the RAddOnInfo property <b>addOnInfo</b>.
     *
     * @param addOnInfo
     */
    public final void addAddOnInfo(RAddOnInfo addOnInfo) {
        this.addOnInfo_.add(addOnInfo);
    }

    /**
     * Gets number of the RAddOnInfo property <b>addOnInfo</b>.
     *
     * @return int
     */
    public final int getAddOnInfoCount() {
        return (addOnInfo_.size());
    }

    /**
     * Gets the RAddOnInfo property <b>addOnInfo</b> by index.
     *
     * @param index
     * @return RAddOnInfo
     */
    public final RAddOnInfo getAddOnInfo(int index) {
        return ((RAddOnInfo)addOnInfo_.get(index));
    }

    /**
     * Sets the RAddOnInfo property <b>addOnInfo</b> by index.
     *
     * @param index
     * @param addOnInfo
     */
    public final void setAddOnInfo(int index, RAddOnInfo addOnInfo) {
        this.addOnInfo_.set(index, addOnInfo);
    }

    /**
     * Adds the RAddOnInfo property <b>addOnInfo</b> by index.
     *
     * @param index
     * @param addOnInfo
     */
    public final void addAddOnInfo(int index, RAddOnInfo addOnInfo) {
        this.addOnInfo_.add(index, addOnInfo);
    }

    /**
     * Remove the RAddOnInfo property <b>addOnInfo</b> by index.
     *
     * @param index
     */
    public final void removeAddOnInfo(int index) {
        this.addOnInfo_.remove(index);
    }

    /**
     * Remove the RAddOnInfo property <b>addOnInfo</b> by object.
     *
     * @param addOnInfo
     */
    public final void removeAddOnInfo(RAddOnInfo addOnInfo) {
        this.addOnInfo_.remove(addOnInfo);
    }

    /**
     * Clear the RAddOnInfo property <b>addOnInfo</b>.
     *
     */
    public final void clearAddOnInfo() {
        this.addOnInfo_.clear();
    }

    /**
     * Gets the element to use object construction.
     *
     * @return Element
     */
    public Element getXMLElement() {
        return (xmlElement);
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<account");
        buffer.append(" name=\"");
        buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getName())));
        buffer.append("\"");
        buffer.append(" password=\"");
        buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getPassword())));
        buffer.append("\"");
        buffer.append(">");
        size = this.addOnInfo_.size();
        for (int i = 0;i < size;i++) {
            RAddOnInfo value = (RAddOnInfo)this.addOnInfo_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</account>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<account");
        buffer.print(" name=\"");
        buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getName())));
        buffer.print("\"");
        buffer.print(" password=\"");
        buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getPassword())));
        buffer.print("\"");
        buffer.print(">");
        size = this.addOnInfo_.size();
        for (int i = 0;i < size;i++) {
            RAddOnInfo value = (RAddOnInfo)this.addOnInfo_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</account>");
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getNameAsString() {
        return (URelaxer.getString(getName()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getPasswordAsString() {
        return (URelaxer.getString(getPassword()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setNameByString(String string) {
        setName(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setPasswordByString(String string) {
        setPassword(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>RAccount</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "account")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (!target.hasAttributeHungry("name")) {
            return (false);
        }
        $match$ = true;
        if (!target.hasAttributeHungry("password")) {
            return (false);
        }
        $match$ = true;
        while (!target.isEmptyElement()) {
            if (!RAddOnInfo.isMatchHungry(target)) {
                break;
            }
            $match$ = true;
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>RAccount</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>RAccount</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
