package jp.gr.java_conf.jaba2.xml.relaxng.rRelaxng;

import java.io.*;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>RNDiv</b> is generated from relaxNg.rxm by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule label="div">
 *   <tag name="div">
 *     <attribute name="datatypeLibrary" type="ngURI"/>
 *   </tag>
 *   <sequence>
 *     <hedgeRef label="grammarContent" occurs="*"/>
 *   </sequence>
 * </elementRule>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule label="div"&gt;
 *   &lt;tag name="div"&gt;
 *     &lt;attribute name="datatypeLibrary" type="ngURI"/&gt;
 *   &lt;/tag&gt;
 *   &lt;sequence&gt;
 *     &lt;hedgeRef label="grammarContent" occurs="*"/&gt;
 *   &lt;/sequence&gt;
 * &lt;/elementRule&gt;
 * </pre>
 *
 * @version relaxNg.rxm (Tue Dec 17 16:01:33 GMT+09:00 2002)
 * @author  Relaxer 1.0RCb (http://www.relaxer.org)
 */
public class RNDiv implements java.io.Serializable, IRNSContainer, IRVisitable, IRNode, IRNIncludeContentChoice, IRNGrammarContentChoice {
    private RNSContext rNSContext_ = new RNSContext(this, "http://relaxng.org/ns/structure/1.0");
    private String datatypeLibrary_;
    // List<IRNGrammarContentChoice>
    private java.util.List grammarContent_ = new java.util.ArrayList();
    private Element xmlElement;
    private IRNode parentRNode_;

    /**
     * Creates a <code>RNDiv</code>.
     *
     */
    public RNDiv() {
    }

    /**
     * Creates a <code>RNDiv</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public RNDiv(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>RNDiv</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public RNDiv(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>RNDiv</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public RNDiv(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>RNDiv</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNDiv(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>RNDiv</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNDiv(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>RNDiv</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNDiv(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>RNDiv</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNDiv(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>RNDiv</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNDiv(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>RNDiv</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNDiv(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>RNDiv</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>RNDiv</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>RNDiv</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        xmlElement = element;
        IRelaxNgFactory factory = RelaxNgFactory.getFactory();
        RStack stack = new RStack(element);
        rNSContext_.declareNamespace(element);
        datatypeLibrary_ = URelaxer.getAttributePropertyAsString(element, "datatypeLibrary");
        grammarContent_.clear();
        while (true) {
            if (RNDefine.isMatch(stack)) {
                addGrammarContent(factory.createRNDefine(stack));
            } else if (RNStart.isMatch(stack)) {
                addGrammarContent(factory.createRNStart(stack));
            } else if (RNInclude.isMatch(stack)) {
                addGrammarContent(factory.createRNInclude(stack));
            } else if (RNDiv.isMatch(stack)) {
                addGrammarContent(factory.createRNDiv(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElementNS("http://relaxng.org/ns/structure/1.0", "div");
        rNSContext_.setupNamespace(element);
        int size;
        if (this.datatypeLibrary_ != null) {
            URelaxer.setAttributePropertyByString(element, "datatypeLibrary", this.datatypeLibrary_);
        }
        size = this.grammarContent_.size();
        for (int i = 0;i < size;i++) {
            IRNGrammarContentChoice value = (IRNGrammarContentChoice)this.grammarContent_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>RNDiv</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>RNDiv</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNDiv</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNDiv</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNDiv</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNDiv</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the RNSContext property <b>rNSContext</b>.
     *
     * @return RNSContext
     */
    public final RNSContext getRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>rNSContext</b>.
     *
     * @param rNSContext
     */
    public final void setRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the String property <b>datatypeLibrary</b>.
     *
     * @return String
     */
    public final String getDatatypeLibrary() {
        return (datatypeLibrary_);
    }

    /**
     * Sets the String property <b>datatypeLibrary</b>.
     *
     * @param datatypeLibrary
     */
    public final void setDatatypeLibrary(String datatypeLibrary) {
        this.datatypeLibrary_ = datatypeLibrary;
    }

    /**
     * Gets the IRNGrammarContentChoice property <b>grammarContent</b>.
     *
     * @return IRNGrammarContentChoice[]
     */
    public final IRNGrammarContentChoice[] getGrammarContent() {
        IRNGrammarContentChoice[] array = new IRNGrammarContentChoice[grammarContent_.size()];
        return ((IRNGrammarContentChoice[])grammarContent_.toArray(array));
    }

    /**
     * Sets the IRNGrammarContentChoice property <b>grammarContent</b>.
     *
     * @param grammarContent
     */
    public final void setGrammarContent(IRNGrammarContentChoice[] grammarContent) {
        this.grammarContent_.clear();
        for (int i = 0;i < grammarContent.length;i++) {
            addGrammarContent(grammarContent[i]);
        }
        for (int i = 0;i < grammarContent.length;i++) {
            grammarContent[i].setParentRNode(this);
        }
    }

    /**
     * Sets the IRNGrammarContentChoice property <b>grammarContent</b>.
     *
     * @param grammarContent
     */
    public final void setGrammarContent(IRNGrammarContentChoice grammarContent) {
        this.grammarContent_.clear();
        addGrammarContent(grammarContent);
        if (grammarContent != null) {
            grammarContent.setParentRNode(this);
        }
    }

    /**
     * Adds the IRNGrammarContentChoice property <b>grammarContent</b>.
     *
     * @param grammarContent
     */
    public final void addGrammarContent(IRNGrammarContentChoice grammarContent) {
        this.grammarContent_.add(grammarContent);
        if (grammarContent != null) {
            grammarContent.setParentRNode(this);
        }
    }

    /**
     * Adds the IRNGrammarContentChoice property <b>grammarContent</b>.
     *
     * @param grammarContent
     */
    public final void addGrammarContent(IRNGrammarContentChoice[] grammarContent) {
        for (int i = 0;i < grammarContent.length;i++) {
            addGrammarContent(grammarContent[i]);
        }
        for (int i = 0;i < grammarContent.length;i++) {
            grammarContent[i].setParentRNode(this);
        }
    }

    /**
     * Gets number of the IRNGrammarContentChoice property <b>grammarContent</b>.
     *
     * @return int
     */
    public final int getGrammarContentCount() {
        return (grammarContent_.size());
    }

    /**
     * Gets the IRNGrammarContentChoice property <b>grammarContent</b> by index.
     *
     * @param index
     * @return IRNGrammarContentChoice
     */
    public final IRNGrammarContentChoice getGrammarContent(int index) {
        return ((IRNGrammarContentChoice)grammarContent_.get(index));
    }

    /**
     * Sets the IRNGrammarContentChoice property <b>grammarContent</b> by index.
     *
     * @param index
     * @param grammarContent
     */
    public final void setGrammarContent(int index, IRNGrammarContentChoice grammarContent) {
        this.grammarContent_.set(index, grammarContent);
    }

    /**
     * Adds the IRNGrammarContentChoice property <b>grammarContent</b> by index.
     *
     * @param index
     * @param grammarContent
     */
    public final void addGrammarContent(int index, IRNGrammarContentChoice grammarContent) {
        this.grammarContent_.add(index, grammarContent);
    }

    /**
     * Remove the IRNGrammarContentChoice property <b>grammarContent</b> by index.
     *
     * @param index
     */
    public final void removeGrammarContent(int index) {
        this.grammarContent_.remove(index);
    }

    /**
     * Remove the IRNGrammarContentChoice property <b>grammarContent</b> by object.
     *
     * @param grammarContent
     */
    public final void removeGrammarContent(IRNGrammarContentChoice grammarContent) {
        this.grammarContent_.remove(grammarContent);
    }

    /**
     * Clear the IRNGrammarContentChoice property <b>grammarContent</b>.
     *
     */
    public final void clearGrammarContent() {
        this.grammarContent_.clear();
    }

    /**
     * Gets the element to use object construction.
     *
     * @return Element
     */
    public Element getXMLElement() {
        return (xmlElement);
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://relaxng.org/ns/structure/1.0");
        buffer.append("<");
        URelaxer.makeQName(prefix, "div", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (datatypeLibrary_ != null) {
            buffer.append(" ");
            buffer.append("datatypeLibrary");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getDatatypeLibrary())));
            buffer.append("\"");
        }
        size = this.grammarContent_.size();
        for (int i = 0;i < size;i++) {
            IRNGrammarContentChoice value = (IRNGrammarContentChoice)this.grammarContent_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.append(">");
        size = this.grammarContent_.size();
        for (int i = 0;i < size;i++) {
            IRNGrammarContentChoice value = (IRNGrammarContentChoice)this.grammarContent_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</");
        URelaxer.makeQName(prefix, "div", buffer);
        buffer.append(">");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://relaxng.org/ns/structure/1.0");
        buffer.print("<");
        URelaxer.makeQName(prefix, "div", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (datatypeLibrary_ != null) {
            buffer.print(" ");
            buffer.print("datatypeLibrary");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getDatatypeLibrary())));
            buffer.print("\"");
        }
        size = this.grammarContent_.size();
        for (int i = 0;i < size;i++) {
            IRNGrammarContentChoice value = (IRNGrammarContentChoice)this.grammarContent_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.print(">");
        size = this.grammarContent_.size();
        for (int i = 0;i < size;i++) {
            IRNGrammarContentChoice value = (IRNGrammarContentChoice)this.grammarContent_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</");
        URelaxer.makeQName(prefix, "div", buffer);
        buffer.print(">");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getDatatypeLibraryAsString() {
        return (URelaxer.getString(getDatatypeLibrary()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setDatatypeLibraryByString(String string) {
        setDatatypeLibrary(URelaxer.getString(string));
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Accepts the Visitor for enter behavior.
     *
     * @param visitor
     * @return boolean
     */
    public boolean enter(IRVisitor visitor) {
        return (visitor.enter(this));
    }

    /**
     * Accepts the Visitor for leave behavior.
     *
     * @param visitor
     */
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode getParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void setParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] getRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(grammarContent_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>RNDiv</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://relaxng.org/ns/structure/1.0", "div")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        while (true) {
            if (RNDefine.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNStart.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNInclude.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNDiv.isMatchHungry(target)) {
                $match$ = true;
            } else {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>RNDiv</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>RNDiv</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
